/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.instancio.generator.Generator;
import org.instancio.generator.Hints;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.generator.misc.EmitGenerator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.Format;

class EmitGeneratorHelper {
    private static final Hints EMIT_NULL_HINT = Hints.builder().with(InternalGeneratorHint.builder().emitNull(true).build()).build();
    private static final GeneratorResult NULL_RESULT = GeneratorResult.create(null, EMIT_NULL_HINT);
    private final ModelContext<?> modelContext;
    private final Map<Generator<?>, Map<InternalNode, List<Object>>> generatorEmittedValues = new HashMap();

    EmitGeneratorHelper(ModelContext<?> modelContext) {
        this.modelContext = modelContext;
    }

    GeneratorResult getResult(EmitGenerator<?> generator, InternalNode node) {
        if (generator.hasMore()) {
            Object result = generator.generate(this.modelContext.getRandom());
            Map emittedValues = this.generatorEmittedValues.computeIfAbsent(generator, k -> new LinkedHashMap());
            this.generatorEmittedValues.put(generator, emittedValues);
            List values = emittedValues.computeIfAbsent(node, k -> new ArrayList());
            values.add(result);
            return result == null ? NULL_RESULT : GeneratorResult.create(result, generator.hints());
        }
        EmitGenerator.WhenEmptyAction whenEmptyAction = generator.getWhenEmptyAction();
        if (whenEmptyAction == EmitGenerator.WhenEmptyAction.EMIT_NULL) {
            return NULL_RESULT;
        }
        if (whenEmptyAction == EmitGenerator.WhenEmptyAction.EMIT_RANDOM) {
            return GeneratorResult.emptyResult();
        }
        Map<InternalNode, List<Object>> emittedValues = this.generatorEmittedValues.getOrDefault(generator, Collections.emptyMap());
        throw Fail.withUsageError(EmitGeneratorHelper.createdErrorMsg(node, emittedValues), new Object[0]);
    }

    private static String createdErrorMsg(InternalNode node, Map<InternalNode, List<Object>> emittedValues) {
        StringBuilder sb = new StringBuilder(1500);
        sb.append("no item is available to emit() for node:").append(Constants.NL).append(Constants.NL).append(Format.nodePathToRootBlock(node)).append(Constants.NL).append(Constants.NL);
        if (emittedValues.isEmpty()) {
            sb.append("Please specify one or more values to emit()").append(Constants.NL).append(Constants.NL).append("    Example:").append(Constants.NL).append("    List<Order> orders = Instancio.ofList(Order.class)").append(Constants.NL).append("        .size(7)").append(Constants.NL).append("        .generate(field(Order::getStatus), gen -> gen.emit()").append(Constants.NL).append("                .items(OrderStatus.RECEIVED, OrderStatus.SHIPPED)").append(Constants.NL).append("                .item(OrderStatus.COMPLETED, 3)").append(Constants.NL).append("                .item(OrderStatus.CANCELLED, 2))").append(Constants.NL).append("        .create();");
        } else {
            sb.append("Previously emitted values:").append(Constants.NL).append(Constants.NL);
            emittedValues.forEach((assignedNode, nodeValues) -> sb.append(" -> Node:   ").append(Format.formatAsTreeNode(assignedNode)).append(Constants.NL).append("    Values: ").append(nodeValues).append(Constants.NL).append(Constants.NL));
            sb.append("Another value is required for:").append(Constants.NL).append(Constants.NL).append(" -> Node:   ").append(Format.formatAsTreeNode(node)).append(Constants.NL).append(Constants.NL).append("But there are no values left to emit.").append(Constants.NL).append("Throwing exception because 'whenEmptyThrowException()' is enabled.");
        }
        return sb.toString();
    }
}

