/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.instancio.internal.nodes.NodeContext;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.nodes.TypeMap;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.Verify;
import org.jetbrains.annotations.Nullable;

public final class InternalNode {
    private final NodeContext nodeContext;
    private final Type type;
    private final Class<?> rawType;
    private final Class<?> targetClass;
    private final Field field;
    private final InternalNode parent;
    private final TypeMap typeMap;
    private final NodeKind nodeKind;
    private final int depth;
    private final boolean cyclic;
    private List<InternalNode> children;
    private int hash;

    private InternalNode(Builder builder) {
        this.nodeContext = builder.nodeContext;
        this.type = builder.type;
        this.rawType = builder.rawType;
        this.targetClass = builder.targetClass;
        this.field = builder.field;
        this.parent = builder.parent;
        this.children = builder.children == null ? Collections.emptyList() : Collections.unmodifiableList(builder.children);
        this.nodeKind = builder.nodeKind;
        this.typeMap = new TypeMap(this.type, this.nodeContext.getRootTypeMap(), builder.additionalTypeMap);
        this.depth = this.parent == null ? 0 : this.parent.depth + 1;
        this.cyclic = builder.cyclic;
    }

    public NodeKind getNodeKind() {
        return this.nodeKind;
    }

    public boolean is(NodeKind nodeKind) {
        return this.nodeKind == nodeKind;
    }

    public boolean isIgnored() {
        return this.nodeKind == NodeKind.IGNORED;
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    boolean isContainer() {
        return this.is(NodeKind.COLLECTION) || this.is(NodeKind.MAP) || this.is(NodeKind.ARRAY) || this.is(NodeKind.CONTAINER);
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.nodeContext = this.nodeContext;
        builder.type = this.type;
        builder.rawType = this.rawType;
        builder.targetClass = this.targetClass;
        builder.field = this.field;
        builder.parent = this.parent;
        builder.children = this.children;
        builder.nodeKind = this.nodeKind;
        builder.cyclic = this.cyclic;
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public NodeContext getNodeContext() {
        return this.nodeContext;
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getRawType() {
        return this.rawType;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Field getField() {
        return this.field;
    }

    public InternalNode getParent() {
        return this.parent;
    }

    public TypeMap getTypeMap() {
        return this.typeMap;
    }

    public InternalNode getOnlyChild() {
        Verify.state(this.getChildren().size() == 1, "Expected one child, but were %s", this.getChildren().size());
        return this.getChildren().get(0);
    }

    public List<InternalNode> getChildren() {
        return this.children;
    }

    void setChildren(List<InternalNode> children) {
        this.children = children;
    }

    boolean hasAncestorWithSameTargetType() {
        for (InternalNode ancestor = this.parent; ancestor != null; ancestor = ancestor.getParent()) {
            if (this.nodeKind != NodeKind.POJO && this.nodeKind != NodeKind.RECORD || !Objects.equals(this.targetClass, ancestor.targetClass) || !Objects.equals(this.type, ancestor.type)) continue;
            return true;
        }
        return false;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalNode other = (InternalNode)o;
        return this.targetClass.equals(other.targetClass) && this.type.equals(other.type) && Objects.equals(this.field, other.field);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.computeHashCode();
        }
        return this.hash;
    }

    private int computeHashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.targetClass.hashCode();
        result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.nodeKind == NodeKind.IGNORED) {
            return "Node[IGNORED]";
        }
        String nodeName = this.field == null ? Format.withoutPackage(this.targetClass) : Format.withoutPackage(this.parent.targetClass) + '.' + this.field.getName();
        return "Node[" + nodeName + ", depth=" + this.depth + ", type=" + Format.withoutPackage(this.type) + ']';
    }

    public String toDisplayString() {
        String nodeName;
        if (this.nodeKind == NodeKind.IGNORED) {
            return "ignored";
        }
        StringBuilder sb = new StringBuilder();
        String string = nodeName = this.field == null ? Format.withoutPackage(this.type) : Format.withoutPackage(this.parent.targetClass) + '.' + this.field.getName();
        if (this.field == null) {
            sb.append("class ").append(nodeName);
        } else {
            sb.append("field ").append(nodeName);
        }
        return sb.toString();
    }

    public static final class Builder {
        private NodeContext nodeContext;
        private Type type;
        private Class<?> rawType;
        private Class<?> targetClass;
        private Field field;
        private InternalNode parent;
        private List<InternalNode> children;
        private NodeKind nodeKind;
        private boolean cyclic;
        private Map<Type, Type> additionalTypeMap = Collections.emptyMap();

        private Builder() {
        }

        public Builder nodeContext(NodeContext nodeContext) {
            this.nodeContext = nodeContext;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder rawType(Class<?> rawType) {
            this.rawType = rawType;
            return this;
        }

        public Builder targetClass(Class<?> targetClass) {
            this.targetClass = targetClass;
            return this;
        }

        public Builder field(@Nullable Field field) {
            this.field = field;
            return this;
        }

        public Builder parent(@Nullable InternalNode parent) {
            this.parent = parent;
            return this;
        }

        public Builder children(List<InternalNode> children) {
            this.children = children;
            return this;
        }

        public Builder nodeKind(NodeKind nodeKind) {
            this.nodeKind = nodeKind;
            return this;
        }

        public Builder cyclic() {
            this.cyclic = true;
            return this;
        }

        public Builder additionalTypeMap(Map<Type, Type> additionalTypeMap) {
            this.additionalTypeMap = additionalTypeMap;
            return this;
        }

        public InternalNode build() {
            return new InternalNode(this);
        }
    }
}

