/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.Field;
import java.util.Objects;
import org.instancio.Node;
import org.instancio.internal.util.Verify;

public final class NodeImpl
implements Node {
    private final Class<?> targetClass;
    private final Field field;

    public NodeImpl(Class<?> targetClass, Field field) {
        this.targetClass = Verify.notNull(targetClass, "targetClass is null", new Object[0]);
        this.field = field;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeImpl)) {
            return false;
        }
        NodeImpl node = (NodeImpl)o;
        return Objects.equals(this.targetClass, node.targetClass) && Objects.equals(this.field, node.field);
    }

    public int hashCode() {
        return Objects.hash(this.targetClass, this.field);
    }

    public String toString() {
        return String.format("Node[targetClass=%s, field=%s]", this.targetClass.getName(), this.field == null ? null : this.field.getName());
    }
}

