/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.instancio.FieldSelectorBuilder;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.selectors.PredicateSelectorBuilderTemplate;
import org.instancio.internal.selectors.PredicateSelectorImpl;
import org.instancio.internal.util.Format;

public class FieldSelectorBuilderImpl
extends PredicateSelectorBuilderTemplate<Field>
implements FieldSelectorBuilder {
    @Override
    protected String apiMethod() {
        return "fields()";
    }

    @Override
    protected PredicateSelectorImpl.Builder createBuilder() {
        return PredicateSelectorImpl.builder().fieldPredicate(this.buildPredicate());
    }

    @Override
    public FieldSelectorBuilder named(String fieldName) {
        ApiValidator.notNull(fieldName, () -> Format.selectorErrorMessage("field name must not be null.", "named", this.description().toString(), new Throwable()));
        this.addPredicate(field -> field.getName().equals(fieldName));
        this.description().append(".named(\"").append(fieldName).append("\")");
        return this;
    }

    @Override
    public FieldSelectorBuilder matching(String regex) {
        ApiValidator.notNull(regex, () -> Format.selectorErrorMessage("regex must not be null.", "matching", this.description().toString(), new Throwable()));
        this.addPredicate(field -> field.getName().matches(regex));
        this.description().append(".matching(\"").append(regex).append("\")");
        return this;
    }

    @Override
    public FieldSelectorBuilder ofType(Class<?> fieldType) {
        ApiValidator.notNull(fieldType, () -> Format.selectorErrorMessage("field type must not be null.", "ofType", this.description().toString(), new Throwable()));
        this.addPredicate(field -> fieldType.isAssignableFrom(field.getType()));
        this.description().append(".ofType(").append(fieldType.getSimpleName()).append(')');
        return this;
    }

    @Override
    public FieldSelectorBuilder declaredIn(Class<?> type) {
        ApiValidator.notNull(type, () -> Format.selectorErrorMessage("declaring type must not be null.", "declaredIn", this.description().toString(), new Throwable()));
        this.addPredicate(field -> field.getDeclaringClass() == type);
        this.description().append(".declaredIn(").append(type.getSimpleName()).append(')');
        return this;
    }

    @Override
    public <A extends Annotation> FieldSelectorBuilder annotated(Class<? extends A> annotation) {
        ApiValidator.notNull(annotation, () -> Format.selectorErrorMessage("field's declared annotation must not be null.", "annotated", this.description().toString(), new Throwable()));
        this.addPredicate(field -> field.getDeclaredAnnotation(annotation) != null);
        this.description().append(".annotated(").append(annotation.getSimpleName()).append(')');
        return this;
    }
}

