/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectUtils {
    private static final Integer DEFAULT_INT = 0;
    private static final Long DEFAULT_LONG = 0L;
    private static final Boolean DEFAULT_BOOLEAN = Boolean.FALSE;
    private static final Double DEFAULT_DOUBLE = 0.0;
    private static final Float DEFAULT_FLOAT = Float.valueOf(0.0f);
    private static final Character DEFAULT_CHAR = Character.valueOf('\u0000');
    private static final Byte DEFAULT_BYTE = 0;
    private static final Short DEFAULT_SHORT = 0;

    public static <T> T defaultValue(Class<T> type) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return (T)DEFAULT_INT;
            }
            if (type == Long.TYPE) {
                return (T)DEFAULT_LONG;
            }
            if (type == Boolean.TYPE) {
                return (T)DEFAULT_BOOLEAN;
            }
            if (type == Double.TYPE) {
                return (T)DEFAULT_DOUBLE;
            }
            if (type == Float.TYPE) {
                return (T)DEFAULT_FLOAT;
            }
            if (type == Character.TYPE) {
                return (T)DEFAULT_CHAR;
            }
            if (type == Byte.TYPE) {
                return (T)DEFAULT_BYTE;
            }
            if (type == Short.TYPE) {
                return (T)DEFAULT_SHORT;
            }
        }
        return null;
    }

    @NotNull
    public static <T> T defaultIfNull(@Nullable T value, @NotNull T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static <T> T defaultIfNull(@Nullable T value, Supplier<T> defaultValue) {
        return value == null ? defaultValue.get() : value;
    }

    private ObjectUtils() {
    }
}

