/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.generators;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.util.Calendar;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.DurationGeneratorSpec;
import org.instancio.generator.specs.InstantGeneratorAsSpec;
import org.instancio.generator.specs.LocalDateTimeGeneratorAsSpec;
import org.instancio.generator.specs.LocalTimeGeneratorAsSpec;
import org.instancio.generator.specs.MonthDayGeneratorSpec;
import org.instancio.generator.specs.OffsetDateTimeGeneratorAsSpec;
import org.instancio.generator.specs.OffsetTimeGeneratorAsSpec;
import org.instancio.generator.specs.PeriodGeneratorSpec;
import org.instancio.generator.specs.TemporalAsGeneratorSpec;
import org.instancio.generator.specs.TemporalGeneratorSpec;
import org.instancio.generator.specs.ZonedDateTimeGeneratorAsSpec;
import org.instancio.internal.generator.sql.SqlDateGenerator;
import org.instancio.internal.generator.sql.TimestampGenerator;
import org.instancio.internal.generator.time.DurationGenerator;
import org.instancio.internal.generator.time.InstantGenerator;
import org.instancio.internal.generator.time.LocalDateGenerator;
import org.instancio.internal.generator.time.LocalDateTimeGenerator;
import org.instancio.internal.generator.time.LocalTimeGenerator;
import org.instancio.internal.generator.time.MonthDayGenerator;
import org.instancio.internal.generator.time.OffsetDateTimeGenerator;
import org.instancio.internal.generator.time.OffsetTimeGenerator;
import org.instancio.internal.generator.time.PeriodGenerator;
import org.instancio.internal.generator.time.YearGenerator;
import org.instancio.internal.generator.time.YearMonthGenerator;
import org.instancio.internal.generator.time.ZonedDateTimeGenerator;
import org.instancio.internal.generator.util.CalendarGenerator;
import org.instancio.internal.generator.util.DateGenerator;

public class TemporalGenerators {
    private final GeneratorContext context;

    public TemporalGenerators(GeneratorContext context) {
        this.context = context;
    }

    public InstantGeneratorAsSpec instant() {
        return new InstantGenerator(this.context);
    }

    public TemporalAsGeneratorSpec<LocalDate> localDate() {
        return new LocalDateGenerator(this.context);
    }

    public LocalTimeGeneratorAsSpec localTime() {
        return new LocalTimeGenerator(this.context);
    }

    public LocalDateTimeGeneratorAsSpec localDateTime() {
        return new LocalDateTimeGenerator(this.context);
    }

    public MonthDayGeneratorSpec monthDay() {
        return new MonthDayGenerator(this.context);
    }

    public OffsetTimeGeneratorAsSpec offsetTime() {
        return new OffsetTimeGenerator(this.context);
    }

    public OffsetDateTimeGeneratorAsSpec offsetDateTime() {
        return new OffsetDateTimeGenerator(this.context);
    }

    public ZonedDateTimeGeneratorAsSpec zonedDateTime() {
        return new ZonedDateTimeGenerator(this.context);
    }

    public TemporalAsGeneratorSpec<YearMonth> yearMonth() {
        return new YearMonthGenerator(this.context);
    }

    public TemporalAsGeneratorSpec<Year> year() {
        return new YearGenerator(this.context);
    }

    public DurationGeneratorSpec duration() {
        return new DurationGenerator(this.context);
    }

    public PeriodGeneratorSpec period() {
        return new PeriodGenerator(this.context);
    }

    public TemporalGeneratorSpec<java.util.Date> date() {
        return new DateGenerator(this.context);
    }

    public TemporalGeneratorSpec<Date> sqlDate() {
        return new SqlDateGenerator(this.context);
    }

    public TemporalGeneratorSpec<Timestamp> timestamp() {
        return new TimestampGenerator(this.context);
    }

    public TemporalGeneratorSpec<Calendar> calendar() {
        return new CalendarGenerator(this.context);
    }
}

