/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.instancio.Assignment;
import org.instancio.CartesianProductApi;
import org.instancio.FilterPredicate;
import org.instancio.GeneratorSpecProvider;
import org.instancio.Model;
import org.instancio.OnCompleteCallback;
import org.instancio.Select;
import org.instancio.TargetSelector;
import org.instancio.TypeTokenSupplier;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.InstancioEngine;
import org.instancio.internal.InternalModel;
import org.instancio.internal.InternalModelDump;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.reflect.ParameterizedTypeImpl;
import org.instancio.internal.util.CartesianList;
import org.instancio.settings.SettingKey;
import org.instancio.settings.Settings;

public class CartesianProductApiImpl<T>
implements CartesianProductApi<T> {
    private final ModelContext.Builder<T> modelContextBuilder;
    private final List<CartesianValues> cartesianValues = new ArrayList<CartesianValues>();

    public CartesianProductApiImpl(Type klass) {
        this.modelContextBuilder = ModelContext.builder(new ParameterizedTypeImpl(List.class, klass));
    }

    public CartesianProductApiImpl(TypeTokenSupplier<T> typeToken) {
        this(ApiValidator.validateTypeToken(typeToken));
    }

    public <E> CartesianProductApiImpl(Model<E> elementModel) {
        InternalModel model = (InternalModel)elementModel;
        this.modelContextBuilder = ModelContext.builder(List.class).useModelAsTypeArgument(model.getModelContext());
    }

    @Override
    @SafeVarargs
    public final <V> CartesianProductApi<T> with(TargetSelector selector, V ... values) {
        ApiValidator.notEmpty(values, "with() requires a non-empty array, but got: %s", Arrays.toString(values));
        CartesianValues cv = new CartesianValues(selector, values);
        this.cartesianValues.add(cv);
        return this;
    }

    @Override
    public CartesianProductApi<T> ignore(TargetSelector selector) {
        this.modelContextBuilder.withIgnored(selector);
        return this;
    }

    @Override
    public <V> CartesianProductApi<T> generate(TargetSelector selector, GeneratorSpecProvider<V> gen) {
        this.modelContextBuilder.withGeneratorSpec(selector, gen);
        return this;
    }

    @Override
    public <V> CartesianProductApi<T> generate(TargetSelector selector, GeneratorSpec<V> spec) {
        this.modelContextBuilder.withGenerator(selector, (Generator)spec);
        return this;
    }

    @Override
    public <V> CartesianProductApi<T> onComplete(TargetSelector selector, OnCompleteCallback<V> callback) {
        this.modelContextBuilder.withOnCompleteCallback(selector, callback);
        return this;
    }

    @Override
    public <V> CartesianProductApi<T> filter(TargetSelector selector, FilterPredicate<V> predicate) {
        this.modelContextBuilder.filter(selector, predicate);
        return this;
    }

    @Override
    public <V> CartesianProductApi<T> set(TargetSelector selector, V value) {
        this.modelContextBuilder.withSupplier(selector, () -> value);
        return this;
    }

    @Override
    public <V> CartesianProductApi<T> setModel(TargetSelector selector, Model<V> model) {
        this.modelContextBuilder.withModel(selector, model);
        return this;
    }

    @Override
    public <V> CartesianProductApi<T> supply(TargetSelector selector, Generator<V> generator) {
        this.modelContextBuilder.withGenerator(selector, generator);
        return this;
    }

    @Override
    public <V> CartesianProductApi<T> supply(TargetSelector selector, Supplier<V> supplier) {
        this.modelContextBuilder.withSupplier(selector, supplier);
        return this;
    }

    @Override
    public CartesianProductApi<T> subtype(TargetSelector selector, Class<?> subtype) {
        this.modelContextBuilder.withSubtype(selector, subtype);
        return this;
    }

    @Override
    public CartesianProductApi<T> assign(Assignment ... assignments) {
        this.modelContextBuilder.withAssignments(assignments);
        return this;
    }

    @Override
    public CartesianProductApi<T> setBlank(TargetSelector selector) {
        this.modelContextBuilder.setBlank(selector);
        return this;
    }

    @Override
    public CartesianProductApi<T> withSeed(long seed) {
        this.modelContextBuilder.withSeed(seed);
        return this;
    }

    @Override
    public CartesianProductApi<T> withMaxDepth(int maxDepth) {
        this.modelContextBuilder.withMaxDepth(maxDepth);
        return this;
    }

    @Override
    public CartesianProductApi<T> withNullable(TargetSelector selector) {
        this.modelContextBuilder.withNullable(selector);
        return this;
    }

    @Override
    public <V> CartesianProductApi<T> withSetting(SettingKey<V> key, V value) {
        this.modelContextBuilder.withSetting(key, value);
        return this;
    }

    @Override
    public CartesianProductApi<T> withSettings(Settings settings) {
        this.modelContextBuilder.withSettings(settings);
        return this;
    }

    @Override
    public CartesianProductApi<T> lenient() {
        this.modelContextBuilder.lenient();
        return this;
    }

    @Override
    public CartesianProductApi<T> verbose() {
        this.modelContextBuilder.verbose();
        return this;
    }

    @Override
    public List<T> list() {
        ArrayList<List> cartesianInputs = new ArrayList<List>();
        for (CartesianValues rangeValue : this.cartesianValues) {
            cartesianInputs.add(rangeValue.values);
        }
        List<List<Object>> combinations = CartesianList.create(cartesianInputs);
        Map<TargetSelector, List<Object>> selectorRangeMap = this.getSelectorValues(combinations);
        for (Map.Entry<TargetSelector, List<Object>> entry : selectorRangeMap.entrySet()) {
            TargetSelector selector = entry.getKey();
            List<Object> valuesToEmit = entry.getValue();
            this.modelContextBuilder.withGeneratorSpec(selector, gen -> gen.emit().ignoreUnused().whenEmptyThrowException().items(valuesToEmit));
        }
        this.modelContextBuilder.withGeneratorSpec(Select.root(), gen -> gen.collection().size(combinations.size()));
        InternalModel<T> model = new InternalModel<T>(this.modelContextBuilder.build());
        InternalModelDump.printVerbose(model);
        return (List)new InstancioEngine(model).createRootObject();
    }

    private Map<TargetSelector, List<Object>> getSelectorValues(List<List<Object>> combinations) {
        LinkedHashMap<TargetSelector, List<Object>> selectorValues = new LinkedHashMap<TargetSelector, List<Object>>();
        for (List<Object> comboValues : combinations) {
            for (int i = 0; i < comboValues.size(); ++i) {
                Object value = comboValues.get(i);
                TargetSelector selector = this.cartesianValues.get(i).selector;
                selectorValues.computeIfAbsent(selector, k -> new ArrayList()).add(value);
            }
        }
        return selectorValues;
    }

    private static final class CartesianValues {
        private final TargetSelector selector;
        private final List<Object> values;

        CartesianValues(TargetSelector selector, Object ... values) {
            this.selector = selector;
            this.values = Arrays.asList(values);
        }
    }
}

