/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.util.ArrayDeque;
import java.util.Queue;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generation.GenerationListener;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.settings.Keys;
import org.instancio.settings.Mode;

final class GeneratedNullValueListener
implements GenerationListener {
    private final ModelContext<?> context;
    private final Queue<InternalNode> queue = new ArrayDeque<InternalNode>();

    private GeneratedNullValueListener(ModelContext<?> context) {
        this.context = context;
    }

    static GenerationListener create(ModelContext<?> context) {
        boolean isLenient = context.getSettings().get(Keys.MODE) == Mode.LENIENT;
        return isLenient || context.getSelectorMaps().allEmpty() ? GenerationListener.NOOP_LISTENER : new GeneratedNullValueListener(context);
    }

    @Override
    public void objectCreated(InternalNode node, GeneratorResult result) {
        if (!result.containsNull()) {
            return;
        }
        this.queue.add(node);
        while (!this.queue.isEmpty()) {
            InternalNode current = this.queue.poll();
            if (result.isIgnored()) {
                this.context.isIgnored(current);
                continue;
            }
            if (!result.containsNull()) continue;
            this.context.isIgnored(current);
            this.context.isNullable(current);
            this.context.getGenerator(current);
            this.context.getCallbacks(current);
            this.context.getSubtypeSelectorMap().getSubtype(current);
            this.context.getAssignments(current);
            this.context.getAssignmentDestinationSelectors(current);
            this.queue.addAll(current.getChildren());
        }
    }
}

