/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.instancio.generator.Generator;
import org.instancio.generator.specs.ArrayGeneratorSpec;
import org.instancio.generator.specs.CollectionGeneratorSpec;
import org.instancio.generator.specs.EnumGeneratorSpec;
import org.instancio.generator.specs.EnumSetGeneratorSpec;
import org.instancio.generator.specs.MapGeneratorSpec;
import org.instancio.generator.specs.OneOfArrayGeneratorSpec;
import org.instancio.generator.specs.OneOfCollectionGeneratorSpec;
import org.instancio.internal.PrimitiveWrapperBiLookup;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.internal.util.TypeUtils;

final class GeneratorSupport {
    private GeneratorSupport() {
    }

    static boolean supports(Generator<?> generator, Class<?> type) {
        if (type == Object.class) {
            return true;
        }
        if (generator instanceof OneOfArrayGeneratorSpec || generator instanceof OneOfCollectionGeneratorSpec) {
            return true;
        }
        if (generator instanceof ArrayGeneratorSpec) {
            return type.isArray();
        }
        if (generator instanceof EnumSetGeneratorSpec) {
            return EnumSet.class.isAssignableFrom(type);
        }
        if (generator instanceof CollectionGeneratorSpec) {
            return (Collection.class.isAssignableFrom(type) || type == Iterable.class) && type != EnumSet.class;
        }
        if (generator instanceof MapGeneratorSpec) {
            return Map.class.isAssignableFrom(type);
        }
        if (generator instanceof EnumGeneratorSpec) {
            return type.isEnum();
        }
        Class<?> typeArg = TypeUtils.getGenericSuperclassTypeArgument(generator.getClass());
        if (typeArg != null) {
            if (type.isAssignableFrom(typeArg)) {
                return true;
            }
            Class<?> equivalent = PrimitiveWrapperBiLookup.getEquivalent(typeArg);
            return equivalent != null && type.isAssignableFrom(equivalent);
        }
        return false;
    }

    static AbstractGenerator<?> unpackGenerator(Generator<?> generator) {
        Generator delegate;
        if (generator instanceof AbstractGenerator) {
            return (AbstractGenerator)generator;
        }
        if (generator instanceof GeneratorDecorator && (delegate = ((GeneratorDecorator)generator).getDelegate()) instanceof AbstractGenerator) {
            return (AbstractGenerator)delegate;
        }
        return null;
    }
}

