/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.instancio.internal.annotation.AbstractAnnotationConsumer;
import org.instancio.internal.annotation.AnnotationConsumer;
import org.instancio.internal.annotation.HibernateBeanValidationAnnotationConsumer;
import org.instancio.internal.annotation.JakartaBeanValidationAnnotationConsumer;
import org.instancio.internal.annotation.JakartaPersistenceAnnotationConsumer;
import org.instancio.internal.annotation.JavaxBeanValidationAnnotationConsumer;
import org.instancio.internal.annotation.JavaxPersistenceAnnotationConsumer;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotationConsumers {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationConsumers.class);
    private static final String JAVAX_PERSISTENCE_CLASS = "javax.persistence.Column";
    private static final String JAKARTA_PERSISTENCE_CLASS = "jakarta.persistence.Column";
    private static final String JAVAX_VALIDATOR_CLASS = "javax.validation.Validation";
    private static final String JAKARTA_VALIDATOR_CLASS = "jakarta.validation.Validation";
    private static final String HIBERNATE_VALIDATOR_CLASS = "org.hibernate.validator.HibernateValidator";

    private AnnotationConsumers() {
    }

    public static List<AnnotationConsumer> get(ModelContext<?> modelContext) {
        Settings settings = modelContext.getSettings();
        boolean jpaEnabled = settings.get(Keys.JPA_ENABLED);
        boolean beanValidationEnabled = settings.get(Keys.BEAN_VALIDATION_ENABLED);
        LOG.trace("Keys.BEAN_VALIDATION_ENABLED={}, Keys.JPA_ENABLED={}", (Object)beanValidationEnabled, (Object)jpaEnabled);
        ArrayList<AbstractAnnotationConsumer> result = new ArrayList<AbstractAnnotationConsumer>();
        if (jpaEnabled) {
            if (ReflectionUtils.loadClass(JAVAX_PERSISTENCE_CLASS) != null) {
                result.add(new JavaxPersistenceAnnotationConsumer());
            }
            if (ReflectionUtils.loadClass(JAKARTA_PERSISTENCE_CLASS) != null) {
                result.add(new JakartaPersistenceAnnotationConsumer());
            }
        }
        if (beanValidationEnabled) {
            if (ReflectionUtils.loadClass(HIBERNATE_VALIDATOR_CLASS) != null) {
                result.add(new HibernateBeanValidationAnnotationConsumer());
            }
            if (ReflectionUtils.loadClass(JAKARTA_VALIDATOR_CLASS) != null) {
                result.add(new JakartaBeanValidationAnnotationConsumer());
            }
            if (ReflectionUtils.loadClass(JAVAX_VALIDATOR_CLASS) != null) {
                result.add(new JavaxBeanValidationAnnotationConsumer());
            }
        }
        return Collections.unmodifiableList(result);
    }
}

