/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.LinkedHashMap;
import java.util.Map;
import org.instancio.TargetSelector;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.settings.Keys;

final class GeneratorInitialiser {
    private final Map<TargetSelector, Class<?>> subtypeMap = new LinkedHashMap();
    private final GeneratorContext context;
    private final AfterGenerate defaultAfterGenerate;

    GeneratorInitialiser(GeneratorContext generatorContext) {
        this.context = generatorContext;
        this.defaultAfterGenerate = generatorContext.getSettings().get(Keys.AFTER_GENERATE_HINT);
    }

    <T> Generator<T> initGenerator(TargetSelector targetSelector, Generator<T> g) {
        g.init(this.context);
        Generator<T> generator = GeneratorDecorator.decorateIfNullAfterGenerate(g, this.defaultAfterGenerate);
        InternalGeneratorHint hint = generator.hints().get(InternalGeneratorHint.class);
        if (hint != null && hint.targetClass() != null) {
            this.subtypeMap.put(targetSelector, hint.targetClass());
        }
        return generator;
    }

    Map<TargetSelector, Class<?>> getSubtypeMap() {
        return this.subtypeMap;
    }
}

