/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.ArrayDeque;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.instancio.TargetSelector;
import org.instancio.internal.ApiMethodSelector;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SelectorMaps;
import org.instancio.internal.nodes.InternalNode;

final class SelectorNodeMatchesCollector {
    private final SelectorMap<?> ignoredSelectorMap;
    private final SelectorMap<?> nullableSelectorMap;
    private final SelectorMap<?> onCompleteCallbackSelectorMap;
    private final SelectorMap<?> filterSelectorMap;
    private final SelectorMap<?> subtypeSelectorMap;
    private final SelectorMap<?> generatorSelectorMap;
    private final SelectorMap<?> assignDestinationToAssignmentsMap;
    private final SelectorMap<?> assignOriginToDestinationSelectorsMap;
    private final SelectorMap<?> setModelSelectorMap;

    SelectorNodeMatchesCollector(SelectorMaps selectorMaps) {
        this.ignoredSelectorMap = selectorMaps.getIgnoreSelectorMap().getSelectorMap();
        this.nullableSelectorMap = selectorMaps.getWithNullableSelectorMap().getSelectorMap();
        this.onCompleteCallbackSelectorMap = selectorMaps.getOnCompleteSelectorMap().getSelectorMap();
        this.filterSelectorMap = selectorMaps.getFilterSelectorMap().getSelectorMap();
        this.subtypeSelectorMap = selectorMaps.getSubtypeSelectorMap().getSelectorMap();
        this.generatorSelectorMap = selectorMaps.getGeneratorSelectorMap().getSelectorMap();
        this.assignDestinationToAssignmentsMap = selectorMaps.getAssignmentSelectorMap().getDestinationToAssignmentsMap();
        this.assignOriginToDestinationSelectorsMap = selectorMaps.getAssignmentSelectorMap().getOriginToDestinationSelectorsMap();
        this.setModelSelectorMap = selectorMaps.getSetModelSelectorMap().getSelectorMap();
    }

    public Map<ApiMethodSelector, Map<TargetSelector, Set<InternalNode>>> getNodeMatches(InternalNode rootNode) {
        EnumMap<ApiMethodSelector, Map<TargetSelector, Set<InternalNode>>> map = new EnumMap<ApiMethodSelector, Map<TargetSelector, Set<InternalNode>>>(ApiMethodSelector.class);
        ArrayDeque<InternalNode> queue = new ArrayDeque<InternalNode>();
        queue.offer(rootNode);
        while (!queue.isEmpty()) {
            InternalNode node = (InternalNode)queue.poll();
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.IGNORE, node, this.ignoredSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.WITH_NULLABLE, node, this.nullableSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.ON_COMPLETE, node, this.onCompleteCallbackSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.FILTER, node, this.filterSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.SUBTYPE, node, this.subtypeSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.GENERATE, node, this.generatorSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.ASSIGN_DESTINATION, node, this.assignDestinationToAssignmentsMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.ASSIGN_ORIGIN, node, this.assignOriginToDestinationSelectorsMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.SET_MODEL, node, this.setModelSelectorMap);
            queue.addAll(node.getChildren());
        }
        return map;
    }

    private static void collectNodes(Map<ApiMethodSelector, Map<TargetSelector, Set<InternalNode>>> resultsMap, ApiMethodSelector method, InternalNode node, SelectorMap<?> selectorMap) {
        Map selectorNodeMap = resultsMap.computeIfAbsent(method, k -> new LinkedHashMap());
        Set<TargetSelector> selectors = selectorMap.getSelectors(node);
        for (TargetSelector selector : selectors) {
            Set nodes = selectorNodeMap.computeIfAbsent(selector, k -> new LinkedHashSet());
            nodes.add(node);
        }
    }

    public Map<ApiMethodSelector, Set<TargetSelector>> getUnusedSelectors() {
        EnumMap<ApiMethodSelector, Set<TargetSelector>> map = new EnumMap<ApiMethodSelector, Set<TargetSelector>>(ApiMethodSelector.class);
        map.put(ApiMethodSelector.IGNORE, SelectorNodeMatchesCollector.collectSelectors(this.ignoredSelectorMap));
        map.put(ApiMethodSelector.WITH_NULLABLE, SelectorNodeMatchesCollector.collectSelectors(this.nullableSelectorMap));
        map.put(ApiMethodSelector.ON_COMPLETE, SelectorNodeMatchesCollector.collectSelectors(this.onCompleteCallbackSelectorMap));
        map.put(ApiMethodSelector.FILTER, SelectorNodeMatchesCollector.collectSelectors(this.filterSelectorMap));
        map.put(ApiMethodSelector.SUBTYPE, SelectorNodeMatchesCollector.collectSelectors(this.subtypeSelectorMap));
        map.put(ApiMethodSelector.GENERATE, SelectorNodeMatchesCollector.collectSelectors(this.generatorSelectorMap));
        map.put(ApiMethodSelector.ASSIGN_DESTINATION, SelectorNodeMatchesCollector.collectSelectors(this.assignDestinationToAssignmentsMap));
        map.put(ApiMethodSelector.ASSIGN_ORIGIN, SelectorNodeMatchesCollector.collectSelectors(this.assignOriginToDestinationSelectorsMap));
        map.put(ApiMethodSelector.SET_MODEL, SelectorNodeMatchesCollector.collectSelectors(this.setModelSelectorMap));
        return map;
    }

    private static Set<TargetSelector> collectSelectors(SelectorMap<?> selectorMap) {
        return selectorMap.getUnusedKeys();
    }
}

