/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.misc;

import java.util.function.Supplier;
import org.instancio.Random;
import org.instancio.documentation.InternalApi;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.Hints;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.misc.GeneratorActionDecorator;
import org.instancio.internal.generator.misc.GeneratorHintsDecorator;
import org.instancio.internal.generator.misc.SupplierAdapter;

@InternalApi
public abstract class GeneratorDecorator<T>
implements Generator<T> {
    private final Generator<T> delegate;

    protected GeneratorDecorator(Generator<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public final void init(GeneratorContext context) {
        this.delegate.init(context);
    }

    @Override
    public final T generate(Random random) {
        return this.delegate.generate(random);
    }

    public final Generator<T> getDelegate() {
        return this.delegate;
    }

    public static <T> Generator<T> decorate(Supplier<T> supplier) {
        return new SupplierAdapter<T>(supplier);
    }

    public static <T> Generator<T> replaceHints(Generator<T> generator, Hints hints) {
        return new GeneratorHintsDecorator<T>(generator, hints);
    }

    public static <T> Generator<T> decorateIfNullAfterGenerate(Generator<T> generator, AfterGenerate defaultAfterGenerate) {
        if (generator instanceof AbstractGenerator || generator instanceof GeneratorDecorator) {
            return generator;
        }
        return new GeneratorActionDecorator<T>(generator, defaultAfterGenerate);
    }
}

