/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.TemporalAsGeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;

abstract class JavaTimeTemporalGenerator<T extends Temporal>
extends AbstractGenerator<T>
implements TemporalAsGeneratorSpec<T> {
    private final T defaultMin;
    private final T defaultMax;
    protected T min;
    protected T max;
    protected TemporalUnit truncateTo;

    JavaTimeTemporalGenerator(GeneratorContext context, T min, T max) {
        super(context);
        this.defaultMin = min;
        this.defaultMax = max;
        this.min = min;
        this.max = max;
    }

    abstract T getLatestPast();

    abstract T getEarliestFuture();

    abstract void validateRange();

    @Override
    public TemporalAsGeneratorSpec<T> past() {
        this.min = this.defaultMin;
        this.max = this.getLatestPast();
        return this;
    }

    @Override
    public TemporalAsGeneratorSpec<T> future() {
        this.min = this.getEarliestFuture();
        this.max = this.defaultMax;
        return this;
    }

    @Override
    public TemporalAsGeneratorSpec<T> min(T min) {
        this.min = (Temporal)ApiValidator.notNull(min, "'min' must not be null");
        return this;
    }

    @Override
    public TemporalAsGeneratorSpec<T> max(T max) {
        this.max = (Temporal)ApiValidator.notNull(max, "'max' must not be null");
        return this;
    }

    @Override
    public TemporalAsGeneratorSpec<T> range(T min, T max) {
        this.min = (Temporal)ApiValidator.notNull(min, "'min' must not be null");
        this.max = (Temporal)ApiValidator.notNull(max, "'max' must not be null");
        this.validateRange();
        return this;
    }

    @Override
    public TemporalAsGeneratorSpec<T> nullable() {
        super.nullable();
        return this;
    }

    TemporalAsGeneratorSpec<T> truncatedTo(TemporalUnit unit) {
        this.truncateTo = unit;
        return this;
    }
}

