/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalUnit;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.OffsetTimeGeneratorAsSpec;
import org.instancio.generator.specs.OffsetTimeSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.time.JavaTimeTemporalGenerator;
import org.instancio.internal.util.Constants;
import org.instancio.support.Global;
import org.jetbrains.annotations.VisibleForTesting;

public class OffsetTimeGenerator
extends JavaTimeTemporalGenerator<OffsetTime>
implements OffsetTimeSpec,
OffsetTimeGeneratorAsSpec {
    private static final int CUT_OFF_BUFFER_MINUTES = 1;
    private static final ZoneOffset ZONE_OFFSET = Constants.ZONE_OFFSET;

    public OffsetTimeGenerator() {
        this(Global.generatorContext());
    }

    public OffsetTimeGenerator(GeneratorContext context) {
        super(context, OffsetTime.MIN, OffsetTime.MAX);
    }

    @Override
    public String apiMethod() {
        return "offsetTime()";
    }

    @Override
    public OffsetTimeGenerator past() {
        super.past();
        return this;
    }

    @Override
    public OffsetTimeGenerator future() {
        super.future();
        return this;
    }

    @Override
    public OffsetTimeGenerator min(OffsetTime min) {
        super.min(min);
        return this;
    }

    @Override
    public OffsetTimeGenerator max(OffsetTime max) {
        super.max(max);
        return this;
    }

    @Override
    public OffsetTimeGenerator range(OffsetTime min, OffsetTime max) {
        super.range(min, max);
        return this;
    }

    @Override
    public OffsetTimeGenerator truncatedTo(TemporalUnit unit) {
        super.truncatedTo(unit);
        return this;
    }

    @Override
    public OffsetTimeGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    OffsetTime getLatestPast() {
        OffsetTime now = this.getNow();
        OffsetTime latestPast = now.minusMinutes(1L);
        return latestPast.isAfter(now) ? OffsetTime.MIN : latestPast;
    }

    @Override
    OffsetTime getEarliestFuture() {
        OffsetTime now = this.getNow();
        OffsetTime earliestFuture = now.plusMinutes(1L);
        return earliestFuture.isBefore(now) ? OffsetTime.MAX : earliestFuture;
    }

    @VisibleForTesting
    OffsetTime getNow() {
        return OffsetTime.now(ZoneOffset.UTC);
    }

    @Override
    void validateRange() {
        ApiValidator.validateStartEnd((OffsetTime)this.min, (OffsetTime)this.max);
    }

    @Override
    protected OffsetTime tryGenerateNonNull(Random random) {
        int hour = random.intRange(((OffsetTime)this.min).getHour(), ((OffsetTime)this.max).getHour());
        int minute = random.intRange(((OffsetTime)this.min).getMinute(), ((OffsetTime)this.max).getMinute());
        int second = random.intRange(((OffsetTime)this.min).getSecond(), ((OffsetTime)this.max).getSecond());
        int nano = random.intRange(((OffsetTime)this.min).getNano(), ((OffsetTime)this.max).getNano());
        OffsetTime result = OffsetTime.of(hour, minute, second, nano, ZONE_OFFSET);
        return this.truncateTo == null ? result : result.truncatedTo(this.truncateTo);
    }
}

