/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.instantiation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.Comparator;
import java.util.function.Predicate;
import org.instancio.internal.instantiation.InstantiationStrategy;
import org.instancio.internal.util.ExceptionUtils;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.ReflectionUtils;
import org.jetbrains.annotations.Nullable;

class LeastArgumentsConstructorInstantiationStrategy
implements InstantiationStrategy {
    private static final Predicate<Constructor<?>> NON_ZERO_ARG = c -> c.getParameterCount() > 0;
    private static final Predicate<Constructor<?>> NOT_BUILDER = c -> c.getParameterCount() != 1 || !"Builder".equals(c.getParameterTypes()[0].getSimpleName());

    LeastArgumentsConstructorInstantiationStrategy() {
    }

    @Override
    public <T> T createInstance(Class<T> klass) {
        Constructor<?> ctor = LeastArgumentsConstructorInstantiationStrategy.getConstructorWithLeastArgs(klass);
        if (ctor == null) {
            return null;
        }
        Constructor<?> constructor = ReflectionUtils.setAccessible(ctor);
        Parameter[] params = constructor.getParameters();
        Object[] args = new Object[params.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = ObjectUtils.defaultValue(params[i].getType());
        }
        try {
            return (T)constructor.newInstance(args);
        }
        catch (Exception ex) {
            ExceptionUtils.logException("Error instantiating {} using {}", ex, klass, this.getClass().getSimpleName());
            return null;
        }
    }

    @Nullable
    private static <T> Constructor<?> getConstructorWithLeastArgs(Class<T> klass) {
        Comparator<Constructor> comparator = Comparator.comparingInt(Constructor::getParameterCount);
        Predicate<Constructor<?>> predicate = NON_ZERO_ARG.and(NOT_BUILDER);
        Constructor<?> result = null;
        for (Constructor<?> ctor : klass.getDeclaredConstructors()) {
            if (!predicate.test(ctor) || result != null && comparator.compare(ctor, result) >= 0) continue;
            result = ctor;
        }
        return result;
    }
}

