/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeContext;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.nodes.resolvers.NodeKindResolverFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PredefinedNodeCreator {
    private final NodeContext nodeContext;
    private final NodeKindResolverFacade nodeKindResolverFacade;

    PredefinedNodeCreator(NodeContext nodeContext, NodeKindResolverFacade nodeKindResolverFacade) {
        this.nodeContext = nodeContext;
        this.nodeKindResolverFacade = nodeKindResolverFacade;
    }

    @Nullable
    InternalNode createFromTemplate(@NotNull Type type, @Nullable Member member, @Nullable InternalNode parent) {
        if (type == OptionalInt.class) {
            return this.createOptional(OptionalInt.class, Integer.TYPE, member, parent);
        }
        if (type == OptionalLong.class) {
            return this.createOptional(OptionalLong.class, Long.TYPE, member, parent);
        }
        if (type == OptionalDouble.class) {
            return this.createOptional(OptionalDouble.class, Double.TYPE, member, parent);
        }
        return null;
    }

    private InternalNode createOptional(Class<?> type, Class<?> childType, Member member, InternalNode parent) {
        InternalNode result = InternalNode.builder().nodeContext(this.nodeContext).nodeKind(NodeKind.CONTAINER).member(member).type(type).rawType(type).targetClass(type).parent(parent).build();
        result.setChildren(Collections.singletonList(InternalNode.builder().nodeContext(this.nodeContext).nodeKind(this.nodeKindResolverFacade.getNodeKind(childType)).type(childType).rawType(childType).targetClass(childType).parent(result).build()));
        return result;
    }
}

