/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.util.List;
import java.util.Optional;
import org.instancio.internal.spi.ProviderEntry;
import org.instancio.spi.InstancioServiceProvider;
import org.instancio.spi.InstancioSpiException;

class TypeResolverFacade {
    private final List<ProviderEntry<InstancioServiceProvider.TypeResolver>> providerEntries;

    TypeResolverFacade(List<ProviderEntry<InstancioServiceProvider.TypeResolver>> providerEntries) {
        this.providerEntries = providerEntries;
    }

    Optional<Class<?>> resolve(Class<?> typeToResolve) {
        Class<?> type = this.resolveViaSPI(typeToResolve);
        return Optional.ofNullable(type);
    }

    private Class<?> resolveViaSPI(Class<?> typeToResolve) {
        for (ProviderEntry<InstancioServiceProvider.TypeResolver> entry : this.providerEntries) {
            Class<?> resolved = entry.getProvider().getSubtype(typeToResolve);
            if (resolved == null) continue;
            if (!typeToResolve.isAssignableFrom(resolved)) {
                throw new InstancioSpiException(String.format("%n%s provided an invalid subtype:%n -> %s%nis not a subtype of:%n -> %s", entry.getInstancioProviderClass(), resolved, typeToResolve));
            }
            return resolved;
        }
        return null;
    }
}

