/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.util.Collections;
import java.util.function.Predicate;
import org.instancio.documentation.InternalApi;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.selectors.InternalSelector;
import org.instancio.internal.selectors.PredicateSelectorImpl;

@InternalApi
public final class BlankSelectors {
    private static final int PRIORITY = Integer.MAX_VALUE;
    private static final InternalSelector ARRAY_SELECTOR = new BlankSelector(node -> node.is(NodeKind.ARRAY), "arraySelector()");
    private static final InternalSelector COLLECTION_SELECTOR = new BlankSelector(node -> node.is(NodeKind.COLLECTION), "collectionSelector()");
    private static final InternalSelector MAP_SELECTOR = new BlankSelector(node -> node.is(NodeKind.MAP), "mapSelector()");
    private static final InternalSelector LEAF_SELECTOR = new BlankSelector(node -> node.getChildren().isEmpty() && node.getParent() != null && !node.getParent().is(NodeKind.ARRAY) && !node.getParent().is(NodeKind.COLLECTION) && !node.getParent().is(NodeKind.MAP), "leafSelector()");

    public static InternalSelector arraySelector() {
        return ARRAY_SELECTOR;
    }

    public static InternalSelector collectionSelector() {
        return COLLECTION_SELECTOR;
    }

    public static InternalSelector mapSelector() {
        return MAP_SELECTOR;
    }

    public static InternalSelector leafSelector() {
        return LEAF_SELECTOR;
    }

    private BlankSelectors() {
    }

    private static final class BlankSelector
    extends PredicateSelectorImpl {
        private BlankSelector(Predicate<InternalNode> predicate, String description) {
            super(Integer.MAX_VALUE, predicate, Collections.emptyList(), null, true, true, description, new Throwable());
        }

        @Override
        public String toString() {
            return String.format("%s.%s.lenient() [internal]", BlankSelectors.class.getSimpleName(), this.getApiInvocationDescription());
        }
    }
}

