/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.spi;

import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.instancio.internal.spi.InternalServiceProvider;
import org.instancio.internal.util.ReflectionUtils;
import org.jetbrains.annotations.Nullable;

public final class InternalServiceProviderImpl
implements InternalServiceProvider {
    @Override
    public InternalServiceProvider.InternalContainerFactoryProvider getContainerFactoryProvider() {
        return new InternalContainerFactoryProviderImpl();
    }

    @Override
    public InternalServiceProvider.InternalGetterMethodFieldResolver getGetterMethodFieldResolver() {
        return new InternalGetterMethodFieldResolverImpl();
    }

    private static final class InternalContainerFactoryProviderImpl
    implements InternalServiceProvider.InternalContainerFactoryProvider {
        private InternalContainerFactoryProviderImpl() {
        }

        @Override
        public <S, T> Function<S, T> getMappingFunction(Class<T> targetType, List<Class<?>> typeArguments) {
            Function<Map, EnumMap> result = null;
            if (targetType == EnumMap.class) {
                result = other -> {
                    if (other.isEmpty()) {
                        return new EnumMap((Class)typeArguments.iterator().next());
                    }
                    return new EnumMap(other);
                };
            }
            return result;
        }

        @Override
        public boolean isContainer(Class<?> type) {
            return false;
        }
    }

    static final class InternalGetterMethodFieldResolverImpl
    implements InternalServiceProvider.InternalGetterMethodFieldResolver {
        private static final String GET_PREFIX = "get";
        private static final String IS_PREFIX = "is";

        InternalGetterMethodFieldResolverImpl() {
        }

        @Override
        public Field resolveField(Class<?> declaringClass, String methodName) {
            Field field;
            if (InternalGetterMethodFieldResolverImpl.hasPrefix(GET_PREFIX, methodName)) {
                Field field2 = InternalGetterMethodFieldResolverImpl.getFieldNameByRemovingPrefix(declaringClass, methodName, GET_PREFIX.length());
                if (field2 != null) {
                    return field2;
                }
            } else if (InternalGetterMethodFieldResolverImpl.hasPrefix(IS_PREFIX, methodName) && (field = InternalGetterMethodFieldResolverImpl.getFieldNameByRemovingPrefix(declaringClass, methodName, IS_PREFIX.length())) != null) {
                return field;
            }
            return ReflectionUtils.getFieldOrNull(declaringClass, methodName);
        }

        @Nullable
        private static Field getFieldNameByRemovingPrefix(Class<?> targetClass, String methodName, int getPrefixLength) {
            char[] ch = methodName.toCharArray();
            ch[getPrefixLength] = Character.toLowerCase(ch[getPrefixLength]);
            String filedName = new String(ch, getPrefixLength, ch.length - getPrefixLength);
            return ReflectionUtils.getFieldOrNull(targetClass, filedName);
        }

        private static boolean hasPrefix(String prefix, String methodName) {
            return methodName.startsWith(prefix) && methodName.length() > prefix.length();
        }
    }
}

