/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.util.List;
import org.instancio.exception.InstancioApiException;
import org.instancio.exception.InstancioException;
import org.instancio.exception.InstancioTerminatingException;
import org.instancio.exception.UnresolvedAssignmentException;
import org.instancio.internal.util.CollectionUtils;
import org.instancio.internal.util.Format;

public final class Fail {
    static final String SUBMIT_BUG_REPORT_MSG = String.format("Instancio encountered an error.%nPlease submit a bug report including the stacktrace:%nhttps://github.com/instancio/instancio/issues", new Object[0]);

    public static InstancioException withInternalError(Throwable cause) {
        if (cause instanceof InstancioException) {
            return (InstancioException)cause;
        }
        return new InstancioException(SUBMIT_BUG_REPORT_MSG, cause);
    }

    public static InstancioException withInternalError(String msg, Object ... args) {
        ErrorArgs errorArgs = Fail.unpackArgs(args);
        String fullErrorMsg = Fail.createInternalErrorMessage(msg, errorArgs);
        return new InstancioException(fullErrorMsg, errorArgs.throwable);
    }

    public static InstancioApiException withUsageError(String msg, Object ... args) {
        ErrorArgs errorArgs = Fail.unpackArgs(args);
        String fullErrorMsg = Fail.createUsageErrorMessage(msg, errorArgs);
        return new InstancioApiException(fullErrorMsg, errorArgs.throwable);
    }

    public static UnresolvedAssignmentException withUnresolvedAssignment(String msg, Object ... args) {
        ErrorArgs errorArgs = Fail.unpackArgs(args);
        String fullErrorMsg = Fail.createUsageErrorMessage(msg, errorArgs);
        return new UnresolvedAssignmentException(fullErrorMsg, errorArgs.throwable);
    }

    private static String createUsageErrorMessage(String msg, ErrorArgs errorArgs) {
        String location = Format.firstNonInstancioStackTraceLine(new Throwable());
        String msgWithArgs = String.format(msg, errorArgs.args);
        return String.format("%n%nError creating an object%n -> at %s%n%nReason: %s%n%n", location, msgWithArgs);
    }

    private static String createInternalErrorMessage(String msg, ErrorArgs errorArgs) {
        String location = Format.firstNonInstancioStackTraceLine(new Throwable());
        String msgWithArgs = String.format(msg, errorArgs.args);
        return String.format("Internal error occurred creating an object.%n%nInternal errors are suppressed by default and%ncan be ignored if not applicable to the current test%n -> at %s%n%nReason: %s%n%n", location, msgWithArgs);
    }

    public static InstancioTerminatingException withFataInternalError(String msg, Object ... args) {
        ErrorArgs errorArgs = Fail.unpackArgs(args);
        String msgWithArgs = String.format(msg, errorArgs.args);
        String fullErrorMsg = String.format("%n%s%n%n -> %s%n", SUBMIT_BUG_REPORT_MSG, msgWithArgs);
        return new InstancioTerminatingException(fullErrorMsg, errorArgs.throwable);
    }

    private static ErrorArgs unpackArgs(Object ... args) {
        int len = args.length;
        if (len > 0 && args[len - 1] instanceof Throwable) {
            return new ErrorArgs(Fail.copyWithoutLastElement(args), (Throwable)args[len - 1]);
        }
        return new ErrorArgs(args, null);
    }

    private static Object[] copyWithoutLastElement(Object ... args) {
        List<Object> list = CollectionUtils.asArrayList(args);
        list.remove(args.length - 1);
        return list.toArray();
    }

    private Fail() {
    }

    private static final class ErrorArgs {
        private final Object[] args;
        private final Throwable throwable;

        private ErrorArgs(Object[] args, Throwable throwable) {
            this.args = args;
            this.throwable = throwable;
        }
    }
}

