/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.holidays.calculator.logic;

import java.time.LocalDate;

public class Easter {
    private Easter() {
    }

    public static LocalDate gauss(int year) {
        int x = year;
        int k = x / 100;
        int m = 15 + (3 * k + 3) / 4 - (8 * k + 13) / 25;
        int s = 2 - (3 * k + 3) / 4;
        int a = x % 19;
        int d = (19 * a + m) % 30;
        int r = (d + a / 11) / 29;
        int eb = 21 + d - r;
        int sz = 7 - (x + x / 4 + s) % 7;
        int eo = 7 - (eb - sz) % 7;
        int es = eb + eo;
        int easterMonth = 2 + (es + 30) / 31;
        int easterDay = es - 31 * (easterMonth / 4);
        return LocalDate.of(year, easterMonth, easterDay);
    }

    public static LocalDate orthodox(int year) {
        int x = (year % 19 * 19 + 15) % 30;
        int day = x + 10 - (5 * year / 4 + x) % 7;
        if (day < 31) {
            return LocalDate.of(year, 4, day);
        }
        return LocalDate.of(year, 5, day - 30);
    }
}

