/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.holidays.calculator.logic.parser.matcher;

import java.time.DayOfWeek;
import java.time.MonthDay;
import java.util.regex.Matcher;
import org.itsallcode.holidays.calculator.logic.parser.matcher.HolidayMatcher;
import org.itsallcode.holidays.calculator.logic.parser.matcher.Patterns;
import org.itsallcode.holidays.calculator.logic.variants.FloatingHoliday;
import org.itsallcode.holidays.calculator.logic.variants.Holiday;

class FloatingDateMatcher
extends HolidayMatcher {
    FloatingDateMatcher() {
        super(Patterns.FLOATING_HOLIDAY);
    }

    @Override
    Holiday createHoliday(Matcher matcher) {
        DayOfWeek dayOfWeek = this.dayOfWeek(matcher.group("dayOfWeek"));
        if (dayOfWeek == null) {
            return null;
        }
        String category = matcher.group("category");
        String name = matcher.group("name");
        int offset = Integer.parseInt(matcher.group("offset"));
        FloatingHoliday.Direction direction = FloatingHoliday.Direction.parse(matcher.group("direction"));
        int month = this.monthNumber(matcher.group("month"));
        String day = matcher.group("day");
        if ("last-day".equals(day)) {
            return new FloatingHoliday(category, name, offset, dayOfWeek, direction, month, FloatingHoliday.Day.LAST);
        }
        return new FloatingHoliday(category, name, offset, dayOfWeek, direction, MonthDay.of(month, Integer.parseInt(day)));
    }

    static class OffsetMatcher
    extends HolidayMatcher {
        OffsetMatcher() {
            super(new FloatingDateMatcher(), Patterns.FLOATING_HOLIDAY_WITH_OFFSET_IN_DAYS);
        }

        @Override
        Holiday createHoliday(Matcher matcher) {
            FloatingHoliday.Direction direction = FloatingHoliday.Direction.parse(matcher.group("direction2"));
            int offset = Integer.parseInt(matcher.group("offset2"));
            return this.createOriginalHoliday(matcher).withOffsetInDays(direction == FloatingHoliday.Direction.BEFORE ? -offset : offset);
        }
    }
}

