/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.holidays.calculator.logic.parser.matcher;

import java.time.DayOfWeek;
import java.time.Month;
import java.time.MonthDay;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.itsallcode.holidays.calculator.logic.conditions.builder.ConditionBuilder;
import org.itsallcode.holidays.calculator.logic.parser.AbbreviationParser;
import org.itsallcode.holidays.calculator.logic.parser.matcher.EasterBasedMatcher;
import org.itsallcode.holidays.calculator.logic.parser.matcher.FixedDateMatcher;
import org.itsallcode.holidays.calculator.logic.parser.matcher.FloatingDateMatcher;
import org.itsallcode.holidays.calculator.logic.parser.matcher.NegatedConditionMatcher;
import org.itsallcode.holidays.calculator.logic.parser.matcher.OrthodoxEasterBasedMatcher;
import org.itsallcode.holidays.calculator.logic.parser.matcher.Patterns;
import org.itsallcode.holidays.calculator.logic.variants.Holiday;

public abstract class HolidayMatcher {
    private static final Pattern MONTH_NAME_PATTERN = Pattern.compile("[a-z]+", 2);
    private final AbbreviationParser<Month> monthNameParser = new AbbreviationParser<Month>(Month.class);
    private final AbbreviationParser<DayOfWeek> dayOfWeekParser = new AbbreviationParser<DayOfWeek>(DayOfWeek.class);
    private final Pattern pattern;
    private final HolidayMatcher originalMatcher;

    public static HolidayMatcher[] matchers() {
        return new HolidayMatcher[]{new NegatedConditionMatcher(new FixedDateMatcher(), Patterns.FIXED_HOLIDAY_CONDITIONAL_NEGATED), new FixedDateMatcher.Conditional(), new FixedDateMatcher(), new FixedDateMatcher.Alternative(Patterns.ALTERNATIVE_DATE_HOLIDAY_NEGATED_DAY_OF_WEEK), new FixedDateMatcher.Alternative(Patterns.ALTERNATIVE_DATE_HOLIDAY), new FloatingDateMatcher.OffsetMatcher(), new FloatingDateMatcher(), new EasterBasedMatcher(), new OrthodoxEasterBasedMatcher()};
    }

    abstract Holiday createHoliday(Matcher var1);

    protected HolidayMatcher(Pattern pattern) {
        this(null, pattern);
    }

    protected HolidayMatcher(HolidayMatcher originalMatcher, Pattern pattern) {
        this.originalMatcher = originalMatcher;
        this.pattern = pattern;
    }

    protected Holiday createOriginalHoliday(Matcher matcher) {
        return this.originalMatcher.createHoliday(matcher);
    }

    public Holiday createHoliday(String line) {
        Matcher matcher = this.pattern.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        return this.createHoliday(matcher);
    }

    protected int monthNumber(String arg) {
        if (MONTH_NAME_PATTERN.matcher(arg).matches()) {
            return this.monthNameParser.getEnumFor(arg).getValue();
        }
        return Integer.parseInt(arg);
    }

    protected MonthDay monthDay(String month, String day) {
        return MonthDay.of(this.monthNumber(month), Integer.parseInt(day));
    }

    protected DayOfWeek dayOfWeek(String prefix) {
        return this.dayOfWeekParser.getEnumFor(prefix);
    }

    protected DayOfWeek[] daysOfWeek(String commaSeparatedList) {
        return Arrays.asList(commaSeparatedList.split(",")).stream().map(this::dayOfWeek).collect(Collectors.toList()).toArray(new DayOfWeek[0]);
    }

    public ConditionBuilder createConditionBuilder(Matcher matcher) {
        return new ConditionBuilder().withDaysOfWeek(this.daysOfWeek(matcher.group("daysOfWeek"))).withPivotDate(this.monthDay(matcher.group("month2"), matcher.group("day2")));
    }
}

