/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.data.ExecFileLoader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.maven.AbstractJacocoMojo;
import org.jacoco.maven.BundleCreator;
import org.jacoco.maven.FileFilter;
import org.jacoco.maven.RuleConfiguration;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.check.IViolationsOutput;
import org.jacoco.report.check.Limit;
import org.jacoco.report.check.Rule;
import org.jacoco.report.check.RulesChecker;

public class CheckMojo
extends AbstractJacocoMojo
implements IViolationsOutput {
    private static final String MSG_SKIPPING = "Skipping JaCoCo execution due to missing execution data file";
    private static final String CHECK_SUCCESS = "All coverage checks have been met.";
    private static final String CHECK_FAILED = "Coverage checks have not been met. See log for details.";
    private List<RuleConfiguration> rules;
    private boolean haltOnFailure;
    private File dataFile;
    private boolean violations;

    private boolean canCheckCoverage() {
        if (!this.dataFile.exists()) {
            this.getLog().info((CharSequence)MSG_SKIPPING);
            return false;
        }
        return true;
    }

    public void executeMojo() throws MojoExecutionException, MojoExecutionException {
        if (!this.canCheckCoverage()) {
            return;
        }
        this.executeCheck();
    }

    private void executeCheck() throws MojoExecutionException {
        IBundleCoverage bundle = this.loadBundle();
        this.violations = false;
        RulesChecker checker = new RulesChecker();
        ArrayList<Rule> checkerrules = new ArrayList<Rule>();
        for (RuleConfiguration r : this.rules) {
            checkerrules.add(r.rule);
        }
        checker.setRules(checkerrules);
        IReportVisitor visitor = checker.createVisitor((IViolationsOutput)this);
        try {
            visitor.visitBundle(bundle, null);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while checking code coverage: " + e.getMessage(), (Exception)e);
        }
        if (this.violations) {
            if (this.haltOnFailure) {
                throw new MojoExecutionException(CHECK_FAILED);
            }
            this.getLog().warn((CharSequence)CHECK_FAILED);
        } else {
            this.getLog().info((CharSequence)CHECK_SUCCESS);
        }
    }

    private IBundleCoverage loadBundle() throws MojoExecutionException {
        FileFilter fileFilter = new FileFilter(this.getIncludes(), this.getExcludes());
        BundleCreator creator = new BundleCreator(this.getProject(), fileFilter);
        try {
            ExecutionDataStore executionData = this.loadExecutionData();
            return creator.createBundle(executionData);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while reading code coverage: " + e.getMessage(), (Exception)e);
        }
    }

    private ExecutionDataStore loadExecutionData() throws IOException {
        ExecFileLoader loader = new ExecFileLoader();
        loader.load(this.dataFile);
        return loader.getExecutionDataStore();
    }

    public void onViolation(ICoverageNode node, Rule rule, Limit limit, String message) {
        this.getLog().warn((CharSequence)message);
        this.violations = true;
    }
}

