/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.html.page;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.IPackageCoverage;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.analysis.ISourceNode;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.internal.ReportOutputFolder;
import org.jacoco.report.internal.html.IHTMLReportContext;
import org.jacoco.report.internal.html.ILinkable;
import org.jacoco.report.internal.html.page.ClassPage;
import org.jacoco.report.internal.html.page.ReportPage;
import org.jacoco.report.internal.html.page.SourceFilePage;
import org.jacoco.report.internal.html.page.TablePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagePage
extends TablePage<IPackageCoverage> {
    private final ISourceFileLocator locator;

    public PackagePage(IPackageCoverage node, ReportPage parent, ISourceFileLocator locator, ReportOutputFolder folder, IHTMLReportContext context) {
        super(node, parent, folder, context);
        this.locator = locator;
    }

    @Override
    public void render() throws IOException {
        Map<String, ILinkable> sourceFiles = this.renderSourceFiles();
        this.renderClasses(sourceFiles);
        super.render();
    }

    private final Map<String, ILinkable> renderSourceFiles() throws IOException {
        HashMap<String, ILinkable> sourceFiles = new HashMap<String, ILinkable>();
        String packagename = ((IPackageCoverage)this.getNode()).getName();
        for (ISourceFileCoverage s : ((IPackageCoverage)this.getNode()).getSourceFiles()) {
            String sourcename = s.getName();
            Reader reader = this.locator.getSourceFile(packagename, sourcename);
            if (reader == null) continue;
            SourceFilePage sourcePage = new SourceFilePage((ISourceNode)s, reader, this.locator.getTabWidth(), this, this.folder, this.context);
            sourcePage.render();
            sourceFiles.put(sourcename, sourcePage);
        }
        return sourceFiles;
    }

    private void renderClasses(Map<String, ILinkable> sourceFiles) throws IOException {
        for (IClassCoverage c : ((IPackageCoverage)this.getNode()).getClasses()) {
            ClassPage page = new ClassPage(c, this, sourceFiles.get(c.getSourceFileName()), this.folder, this.context);
            page.render();
            this.addItem(page);
        }
    }

    @Override
    protected String getOnload() {
        return "initialSort(['breadcrumb', 'coveragetable'])";
    }

    @Override
    protected String getFileName() {
        return "index.html";
    }

    @Override
    public String getLinkLabel() {
        return this.context.getLanguageNames().getPackageName(((IPackageCoverage)this.getNode()).getName());
    }
}

