/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.maven;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.jamon.compiler.TemplateProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJamonMojo
extends AbstractMojo {
    private MavenProject project;
    private int staleMillis;
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();

    protected abstract File templateSourceDir();

    protected abstract File templateOutputDir();

    /*
     * Exception decompiling
     */
    private ClassLoader classLoader() throws MojoExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void doExecute() throws MojoExecutionException {
        List<File> jamonSources = this.collectSources();
        if (jamonSources.size() > 0) {
            this.getLog().info((CharSequence)("Translating " + jamonSources.size() + " templates from " + this.templateSourceDir().getPath() + " to " + this.templateOutputDir().getPath()));
            TemplateProcessor processor = new TemplateProcessor(this.templateOutputDir(), this.templateSourceDir(), this.classLoader());
            for (File f : jamonSources) {
                try {
                    processor.generateSource(f.getPath());
                }
                catch (IOException e) {
                    throw new MojoExecutionException("unable to translate template", (Exception)e);
                }
            }
        }
    }

    private List<File> collectSources() throws MojoExecutionException {
        return this.accumulateSources(this.templateSourceDir());
    }

    private List<File> accumulateSources(File p_templateSourceDir) throws MojoExecutionException {
        if (p_templateSourceDir == null) {
            return Collections.emptyList();
        }
        SourceInclusionScanner scanner = this.getSourceInclusionScanner(this.staleMillis);
        scanner.addSourceMapping((SourceMapping)new SuffixMapping(".jamon", ".java"));
        scanner.addSourceMapping((SourceMapping)new SuffixMapping(".jamon", "Impl.java"));
        LinkedHashSet<File> staleFiles = new LinkedHashSet<File>();
        for (File f : p_templateSourceDir.listFiles()) {
            if (!f.isDirectory()) continue;
            try {
                Set includedSources = scanner.getIncludedSources(f.getParentFile(), this.templateOutputDir());
                staleFiles.addAll(includedSources);
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Error scanning source root: '" + p_templateSourceDir.getPath() + "' " + "for stale files to recompile.", (Exception)((Object)e));
            }
        }
        return this.relativizeFiles(staleFiles);
    }

    private List<File> relativizeFiles(Set<File> files) {
        ArrayList<File> result = new ArrayList<File>();
        for (File file : files) {
            URI templateSourceUri = this.templateSourceDir().toURI();
            result.add(new File(templateSourceUri.relativize(file.toURI()).getPath()));
        }
        return result;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    private SourceInclusionScanner getSourceInclusionScanner(int staleMillis) {
        return new StaleSourceScanner((long)staleMillis, this.includes.isEmpty() ? Collections.singleton("**/*.jamon") : this.includes, this.excludes);
    }
}

