/**
 * Copyright 2007 The JA-SIG Collaborative.  All rights reserved.
 * See license distributed with this file and
 * available online at http://www.uportal.org/license.html
 */
package org.jasig.web.servlet.mvc;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.Validate;
import org.jasig.web.service.AjaxPortletSupportService;
import org.jasig.web.util.ModelPasser;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

/**
 * Retrieves the model from the porlet using {@link ModelPasser#getModelFromPortlet(HttpServletRequest, HttpServletResponse, String)}
 * then renders the specified view with the model. If no model is found a ServletException is thrown.
 * 
 * By default requireSession is set to true and the viewName is set to {@link #DEFAULT_VIEW_NAME}
 * 
 * @author Eric Dalquist
 * @version $Revision$
 */
public class AjaxResponseController extends AbstractController {
    public static final String DEFAULT_VIEW_NAME = "jsonView";

    private final AjaxPortletSupportService ajaxPortletSupportService = new AjaxPortletSupportService();
    private String viewName = DEFAULT_VIEW_NAME;
    
    public AjaxResponseController() {
        this.setRequireSession(true);
    }
    
    /**
     * @see AjaxPortletSupportService#getModelPasser()
     */
    public ModelPasser getModelPasser() {
        return this.ajaxPortletSupportService.getModelPasser();
    }
    /**
     * @see AjaxPortletSupportService#setModelPasser(ModelPasser)
     */
    public void setModelPasser(ModelPasser modelPasser) {
        this.ajaxPortletSupportService.setModelPasser(modelPasser);
    }
    
    public String getViewName() {
        return this.viewName;
    }
    /**
     * The view used to render the model. Defaults to {@link #DEFAULT_VIEW_NAME}
     */
    public void setViewName(String viewName) {
        Validate.notNull(viewName);
        this.viewName = viewName;
    }


    /* (non-Javadoc)
     * @see org.springframework.web.servlet.mvc.AbstractController#handleRequestInternal(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        final Map<Object, Object> model = this.ajaxPortletSupportService.getAjaxModel(request, response);
        
        model.put("test", "bar");
        
        return new ModelAndView(this.viewName, model);
    }
}
