/**
 * Copyright 2007 The JA-SIG Collaborative.  All rights reserved.
 * See license distributed with this file and
 * available online at http://www.uportal.org/license.html
 */
package org.jasig.web.util;

import java.util.Map;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Uses the application scoped session to share the model between the portlet and servlet
 * 
 * @author Eric Dalquist
 * @version $Revision$
 */
public class DefaultModelPasser implements ModelPasser {
    protected final Log logger = LogFactory.getLog(this.getClass());

    /* (non-Javadoc)
     * @see org.jasig.web.util.ModelPasser#getModelFromPortlet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, java.lang.String)
     */
    @SuppressWarnings("unchecked")
    public Map<Object, Object> getModelFromPortlet(HttpServletRequest request, HttpServletResponse response, String key) {
        final HttpSession session = request.getSession(false);
        if (session == null) {
            this.logger.debug("No session available, returning null for key '" + key + "'");
            return null;
        }
        
        final Map<Object, Object> model = (Map<Object, Object>) session.getAttribute(key);

        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Found model '" + model + "' in HttpSession for key '" + key + "'");
        }

        session.removeAttribute(key);
        return model;
    }

    /* (non-Javadoc)
     * @see org.jasig.web.util.ModelPasser#passModelToServlet(javax.portlet.ActionRequest, javax.portlet.ActionResponse, java.lang.String, java.util.Map)
     */
    public void passModelToServlet(ActionRequest request, ActionResponse response, String key, Map<Object, Object> model) {
        final PortletSession portletSession = request.getPortletSession();
        portletSession.setAttribute(key, model, PortletSession.APPLICATION_SCOPE);

        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Stored model '" + model + "' in PortletSession for key '" + key
                    + "' at the application scope");
        }
    }
}
