/**
 * Copyright 2007 The JA-SIG Collaborative.  All rights reserved.
 * See license distributed with this file and
 * available online at http://www.uportal.org/license.html
 */
package org.jasig.web.util;

import java.security.SecureRandom;

import javax.portlet.PortletSession;

import org.apache.commons.codec.binary.Base64;

/**
 * Uses {@link SecureRandom} to generate a secure 240bit key
 * 
 * @author Eric Dalquist
 * @version $Revision$
 */
public class SecureSessionKeyGenerator implements SessionKeyGenerator {
    public static final String UNIQUE_KEY_SEQ = SecureSessionKeyGenerator.class.getName() + ".UNIQUE_KEY_SEQ";
    
    private final SecureRandom secureRandom = new SecureRandom();
    
    /* (non-Javadoc)
     * @see org.jasig.portlet.notepad.util.SessionKeyGenerator#getNextSessionKey(javax.portlet.PortletSession)
     */
    public String getNextSessionKey(PortletSession session) {
        final byte[] keyBytes = new byte[30];
        this.secureRandom.nextBytes(keyBytes);
        return new String(Base64.encodeBase64(keyBytes));
    }

}
