/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.web.util;

import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.web.util.LoggingLRUMap;
import org.jasig.web.util.ModelPasser;
import org.springframework.web.portlet.util.PortletUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUTrackingModelPasser
implements ModelPasser {
    private static final String MODEL_CACHE_KEY = LRUTrackingModelPasser.class.getName() + ".MODEL_CACHE_KEY";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int maxSize = 100;

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public Map<Object, Object> getModelFromPortlet(HttpServletRequest request, HttpServletResponse response, String key) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this.logger.debug((Object)("No session available, returning null for key '" + key + "'"));
            return null;
        }
        Map modelCache = (Map)session.getAttribute(MODEL_CACHE_KEY);
        if (modelCache == null) {
            this.logger.debug((Object)("No model cache Map in session, returning null for key '" + key + "'"));
            return null;
        }
        Map model = (Map)modelCache.get(key);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found model '" + model + "' in HttpSession for key '" + key + "'"));
        }
        return model;
    }

    @Override
    public void passModelToServlet(ActionRequest request, ActionResponse response, String key, Map<Object, Object> model) {
        PortletSession portletSession = request.getPortletSession();
        Map<String, Map<Object, Object>> modelCache = this.getModelCache(portletSession);
        modelCache.put(key, model);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Stored model '" + model + "' in cache Map for key '" + key + "'"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Map<Object, Object>> getModelCache(PortletSession portletSession) {
        Object modelCache;
        Object object = PortletUtils.getSessionMutex((PortletSession)portletSession);
        synchronized (object) {
            modelCache = (Map)portletSession.getAttribute(MODEL_CACHE_KEY, 1);
            if (modelCache == null) {
                modelCache = new LoggingLRUMap(this.maxSize);
            }
            portletSession.setAttribute(MODEL_CACHE_KEY, modelCache, 1);
        }
        return modelCache;
    }
}

