/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.irclog.events;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibble.pircbot.PircBot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IrcEvent {
    private static final List<String> PROPERTIES = Collections.unmodifiableList(Arrays.asList("date"));
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final Date date = new Date();
    protected final PircBot source;

    public IrcEvent(PircBot source) {
        this.source = source;
    }

    public Date getDate() {
        return this.date;
    }

    public PircBot getSource() {
        return this.source;
    }

    public final Object[] getArguments() {
        List<String> properties = this.getArgumentProperties();
        Object[] arguments = new Object[properties.size()];
        int index = 0;
        for (String property : properties) {
            Object value;
            try {
                value = PropertyUtils.getProperty((Object)this, (String)property);
            }
            catch (IllegalAccessException iae) {
                this.logger.error((Object)("Cannot access bean property '" + property + "' on bean '" + this + "'"), (Throwable)iae);
                throw new RuntimeException("Cannot access bean property '" + property + "' on bean '" + this + "'", iae);
            }
            catch (InvocationTargetException ite) {
                this.logger.error((Object)("Cannot access bean property '" + property + "' on bean '" + this + "'"), (Throwable)ite);
                throw new RuntimeException("Cannot access bean property '" + property + "' on bean '" + this + "'", ite);
            }
            catch (NoSuchMethodException nsme) {
                this.logger.error((Object)("Property '" + property + "' does not exist on bean '" + this + "'"), (Throwable)nsme);
                throw new RuntimeException("Property '" + property + "' does not exist on bean '" + this + "'", nsme);
            }
            arguments[index] = value;
            ++index;
        }
        return arguments;
    }

    protected List<String> getArgumentProperties() {
        return PROPERTIES;
    }

    public final String getEventCode() {
        return this.getClass().getName();
    }
}

