/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.irclog.events.handlers;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.jasig.irclog.events.IrcEvent;
import org.jasig.irclog.events.JoinEvent;
import org.jasig.irclog.events.handlers.IrcEventHandler;
import org.jibble.pircbot.PircBot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelNotifier
implements IrcEventHandler {
    private String defaultOnJoinMessage;
    private Map<String, String> onJoinMessages = new HashMap<String, String>(0);

    public String getDefaultOnJoinMessage() {
        return this.defaultOnJoinMessage;
    }

    public void setDefaultOnJoinMessage(String defaultOnJoinMessage) {
        this.defaultOnJoinMessage = defaultOnJoinMessage;
    }

    public Map<String, String> getOnJoinMessages() {
        return this.onJoinMessages;
    }

    public void setOnJoinMessages(Map<String, String> onJoinMessages) {
        Validate.notNull(onJoinMessages, (String)"OnJoinMessages Map can not be null");
        this.onJoinMessages = onJoinMessages;
    }

    public void addOnJoinMessage(String channel, String message) {
        this.onJoinMessages.put(channel, message);
    }

    @Override
    public void handleEvent(IrcEvent event) {
        PircBot bot = event.getSource();
        if (event instanceof JoinEvent) {
            JoinEvent joinEvent = (JoinEvent)event;
            String sender = joinEvent.getSender();
            String channel = joinEvent.getChannel();
            String message = this.getOnJoinMessage(channel);
            if (sender.equalsIgnoreCase(bot.getNick())) {
                bot.sendNotice(channel, message);
            } else {
                bot.sendNotice(sender, message);
            }
        }
    }

    protected String getOnJoinMessage(String channel) {
        String message;
        if (this.onJoinMessages != null && (message = this.onJoinMessages.get(channel)) != null) {
            return message;
        }
        return this.defaultOnJoinMessage;
    }
}

