/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.irclog.events.handlers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.irclog.events.IrcEvent;
import org.jasig.irclog.events.handlers.IrcEventHandler;
import org.jasig.irclog.events.handlers.filter.EventFilter;

public class FilteringEventHandler
implements IrcEventHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private EventFilter eventFilter;
    private IrcEventHandler targetHandler;

    public EventFilter getEventFilter() {
        return this.eventFilter;
    }

    public void setEventFilter(EventFilter eventFilter) {
        this.eventFilter = eventFilter;
    }

    public IrcEventHandler getTargetHandler() {
        return this.targetHandler;
    }

    public void setTargetHandler(IrcEventHandler targetHandler) {
        if (targetHandler == this) {
            throw new IllegalArgumentException("Setting self as targetHandler, this would create an infinite loop");
        }
        this.targetHandler = targetHandler;
    }

    public void handleEvent(IrcEvent event) {
        boolean passed = this.eventFilter.filterEvent(event);
        if (passed) {
            this.logger.debug((Object)("Event '" + event + "' passed filter '" + this.eventFilter + "'"));
            this.targetHandler.handleEvent(event);
        } else {
            this.logger.debug((Object)("Event '" + event + "' failed filter '" + this.eventFilter + "'"));
        }
    }
}

