/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.irclog.events.handlers;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.irclog.events.IrcEvent;
import org.jasig.irclog.events.handlers.IrcEventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplittingEventHandler
implements IrcEventHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Set<IrcEventHandler> handlers = new HashSet<IrcEventHandler>(0);
    private boolean recoverExceptions = true;

    public Set<IrcEventHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(Set<IrcEventHandler> handlers) {
        Validate.notNull(handlers, (String)"Handlers Set can not be null");
        this.handlers = handlers;
    }

    public void registerEventHandler(IrcEventHandler handler) {
        this.handlers.add(handler);
    }

    public boolean isRecoverExceptions() {
        return this.recoverExceptions;
    }

    public void setRecoverExceptions(boolean recoverExceptions) {
        this.recoverExceptions = recoverExceptions;
    }

    @Override
    public void handleEvent(IrcEvent event) {
        for (IrcEventHandler handler : this.handlers) {
            try {
                handler.handleEvent(event);
            }
            catch (Throwable t) {
                if (this.recoverExceptions) {
                    this.logger.warn((Object)("Event Handler '" + this.handlers + "' threw an exception, execution will continue."), t);
                    continue;
                }
                this.logger.error((Object)("Event Handler '" + this.handlers + "' threw an exception."), t);
                throw new RuntimeException("Event Handler '" + this.handlers + "' threw an exception.", t);
            }
        }
    }
}

