/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.irclog.events.handlers.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jasig.irclog.events.IrcEvent;
import org.jasig.irclog.events.TargetedEvent;
import org.jasig.irclog.events.handlers.filter.EventFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetedEventFilter
implements EventFilter {
    private Set<String> targets = new HashSet<String>(0);

    public TargetedEventFilter() {
    }

    public TargetedEventFilter(String ... target) {
        this.targets.addAll(Arrays.asList(target));
    }

    public Set<String> getTargets() {
        return this.targets;
    }

    public void setTargets(Set<String> targets) {
        Validate.notNull(targets, (String)"targets Set cannot be null");
        this.targets = targets;
    }

    @Override
    public boolean filterEvent(IrcEvent event) {
        if (event instanceof TargetedEvent) {
            TargetedEvent targetedEvent = (TargetedEvent)event;
            String target = targetedEvent.getTarget();
            return this.targets.contains(target);
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("targets", this.targets).toString();
    }
}

