/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.irclog.messages;

import java.util.ArrayList;
import org.jasig.irclog.messages.MessageHandler;
import org.jasig.irclog.messages.MessageHandlerWrapper;

public class BufferingMessageHandler
extends MessageHandlerWrapper {
    private final ArrayList<String> messages = new ArrayList();
    private int messageBufferSize;

    public BufferingMessageHandler() {
        this.setMessageBufferSize(8);
    }

    public int getMessageBufferSize() {
        return this.messageBufferSize;
    }

    public void setMessageBufferSize(int messageBufferSize) {
        this.messageBufferSize = messageBufferSize;
        this.messages.ensureCapacity(messageBufferSize);
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessages(String ... messages) {
        ArrayList<String> arrayList = this.messages;
        synchronized (arrayList) {
            for (String message : messages) {
                this.logger.debug((Object)("Adding '" + message + "' to the buffer. (" + (this.messages.size() + 1) + " of " + this.messageBufferSize + " messages in buffer)"));
                this.messages.add(message);
                if (this.messages.size() != this.messageBufferSize) continue;
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        String[] messages;
        ArrayList<String> arrayList = this.messages;
        synchronized (arrayList) {
            if (this.messages.size() == 0) {
                return;
            }
            messages = this.messages.toArray(new String[this.messages.size()]);
            this.messages.clear();
        }
        this.logger.debug((Object)("Flushing '" + messages.length + "' messages from buffer"));
        this.messageHandler.handleMessages(messages);
    }
}

