/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.irclog.messages;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.Page;
import org.jasig.irclog.config.ConfluenceServer;
import org.jasig.irclog.messages.MessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfluenceMessageHandler
implements MessageHandler {
    protected Log logger = LogFactory.getLog(this.getClass());
    private Map<String, String> messageEscapePairs = new HashMap<String, String>();
    private ConfluenceServer confluenceServer;
    private String spaceKey;
    private List<SimpleDateFormat> logPagesTitleFormats;
    private String childPageLinkFormat = "'{'children:depth=1'}'";

    public ConfluenceMessageHandler() {
        this.messageEscapePairs.put("\\[", "\\\\[");
        this.messageEscapePairs.put("\\]", "\\\\]");
    }

    public Map<String, String> getMessageEscapePairs() {
        return this.messageEscapePairs;
    }

    public void setMessageEscapePairs(Map<String, String> messageEscapePairs) {
        this.messageEscapePairs = messageEscapePairs;
    }

    public ConfluenceServer getConfluenceServer() {
        return this.confluenceServer;
    }

    public void setConfluenceServer(ConfluenceServer confluenceServer) {
        this.confluenceServer = confluenceServer;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public String getChildPageLinkFormat() {
        return this.childPageLinkFormat;
    }

    public void setChildPageLinkFormat(String childPageLinkFormat) {
        this.childPageLinkFormat = childPageLinkFormat;
    }

    public List<String> getLogPagesTitleFormats() {
        ArrayList<String> stringFormats = new ArrayList<String>(this.logPagesTitleFormats.size());
        for (SimpleDateFormat dateFormat : this.logPagesTitleFormats) {
            stringFormats.add(dateFormat.toPattern());
        }
        return stringFormats;
    }

    public void setLogPagesTitleFormats(List<String> logPagesTitleFormats) {
        Validate.notNull(logPagesTitleFormats, (String)"logPagesTitleFormats List can not be null");
        ArrayList<SimpleDateFormat> dateFormats = new ArrayList<SimpleDateFormat>(logPagesTitleFormats.size());
        for (String stringFormat : logPagesTitleFormats) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(stringFormat);
            dateFormats.add(dateFormat);
        }
        this.logPagesTitleFormats = dateFormats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessages(String ... messages) {
        if (messages == null || messages.length == 0) {
            return;
        }
        try {
            Confluence confluence = new Confluence(this.confluenceServer.getEndpoint());
            confluence.login(this.confluenceServer.getUserName(), this.confluenceServer.getPassword());
            Date now = new Date();
            Page parentPage = null;
            Page targetPage = null;
            for (SimpleDateFormat pageTitleDateFormat : this.logPagesTitleFormats) {
                String pageName;
                parentPage = targetPage;
                SimpleDateFormat simpleDateFormat = pageTitleDateFormat;
                synchronized (simpleDateFormat) {
                    pageName = pageTitleDateFormat.format(now);
                }
                try {
                    targetPage = confluence.getPage(this.spaceKey, pageName);
                }
                catch (Exception e) {
                    targetPage = null;
                }
                if (targetPage != null) continue;
                targetPage = this.createLogPage(confluence, parentPage, pageName);
            }
            String content = targetPage.getContent();
            StringBuilder contentBuilder = content == null ? new StringBuilder() : new StringBuilder(content);
            for (String message : messages) {
                String escapedMessage = this.escapeMessage(message);
                contentBuilder.append(escapedMessage).append("\n");
            }
            targetPage.setContent(contentBuilder.toString());
            confluence.storePage(targetPage);
            confluence.logout();
        }
        catch (Exception e) {
            if (messages.length == 1) {
                this.logger.error((Object)("An exception occured while attempting to update Confluence with message '" + messages[0] + "'"), (Throwable)e);
            }
            this.logger.warn((Object)("An exception occured while attempting to update Confluence with messages '" + Arrays.asList(messages) + "'. The updates will be attempted individually."), (Throwable)e);
            for (String message : messages) {
                this.handleMessages(message);
            }
        }
    }

    @Override
    public void flush() {
    }

    protected String escapeMessage(String message) {
        for (Map.Entry<String, String> entry : this.messageEscapePairs.entrySet()) {
            message = message.replaceAll(entry.getKey(), entry.getValue());
        }
        return message;
    }

    protected Page createLogPage(Confluence confluence, Page parent, String pageName) throws Exception {
        Page page = new Page(new HashMap());
        page.setTitle(pageName);
        page.setSpace(this.spaceKey);
        if (parent != null) {
            page.setParentId(parent.getId());
        }
        page = confluence.storePage(page);
        if (parent != null) {
            this.addLinkToChild(confluence, parent, pageName);
        }
        return page;
    }

    protected void addLinkToChild(Confluence confluence, Page parent, String pageName) throws Exception {
        String content = parent.getContent();
        StringBuilder contentBuilder = content == null ? new StringBuilder() : new StringBuilder(content);
        if (this.childPageLinkFormat != null) {
            String childLink = MessageFormat.format(this.childPageLinkFormat, new Date(), parent.getTitle(), pageName);
            if (contentBuilder.indexOf(childLink) < 0) {
                contentBuilder.append(childLink);
            }
            parent.setContent(contentBuilder.toString());
            confluence.storePage(parent);
        }
    }
}

