/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.irclog.messages;

import java.util.HashMap;
import java.util.Map;
import org.jasig.irclog.messages.MessageHandlerWrapper;

public class XmlEscapingMessageHandler
extends MessageHandlerWrapper {
    private static final Map<Character, CharSequence> CHAR_LOOKUP = new HashMap<Character, CharSequence>();

    public void handleMessages(String ... messages) {
        String[] escapedMessages = new String[messages.length];
        for (int index = 0; index < messages.length; ++index) {
            String escapedMessage;
            String message = messages[index];
            escapedMessages[index] = escapedMessage = this.escapeXml(message);
        }
        super.handleMessages(escapedMessages);
    }

    protected String escapeXml(String message) {
        if (message == null) {
            return null;
        }
        int messageLength = message.length();
        int lastReplacement = 0;
        StringBuilder escapedBuilder = null;
        for (int index = 0; index < messageLength; ++index) {
            char c = message.charAt(index);
            CharSequence replacement = CHAR_LOOKUP.get(Character.valueOf(c));
            if (replacement == null) continue;
            if (lastReplacement == 0) {
                escapedBuilder = new StringBuilder(messageLength + 8);
            }
            if (lastReplacement < index) {
                String subSeq = message.substring(lastReplacement, index);
                escapedBuilder.append(subSeq);
            }
            lastReplacement = index + 1;
            escapedBuilder.append(replacement);
        }
        if (lastReplacement == 0) {
            this.logger.debug((Object)("No XML escaping required, returning original message '" + message + "'"));
            return message;
        }
        if (lastReplacement < messageLength) {
            CharSequence subSeq = message.subSequence(lastReplacement, messageLength);
            escapedBuilder.append(subSeq);
        }
        String escapedMessage = escapedBuilder.toString();
        this.logger.debug((Object)("Returning escaped message '" + escapedMessage + "' created from '" + message + "'"));
        return escapedMessage;
    }

    static {
        CHAR_LOOKUP.put(Character.valueOf('&'), "&amp;");
        CHAR_LOOKUP.put(Character.valueOf('<'), "&lt;");
        CHAR_LOOKUP.put(Character.valueOf('>'), "&gt;");
        CHAR_LOOKUP.put(Character.valueOf('\"'), "&#034;");
        CHAR_LOOKUP.put(Character.valueOf('\''), "&#039;");
    }
}

