/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.irclog.messages.support;

import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.irclog.messages.MessageHandler;

public class MessageHandlerFlusher {
    private static final Random RND = new Random();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Timer timer = new Timer("MessageHandlerTimer[" + this.toString() + "]", true);
    private TimerTask flushTask;
    private MessageHandler messageHandler;
    private long period;

    public int getPeriod() {
        return (int)(this.period / 1000L);
    }

    public synchronized void setPeriod(int period) {
        this.period = period * 1000;
        if (this.flushTask != null) {
            this.flushTask.cancel();
        }
        this.flushTask = new FlushMessageHandlerTask();
        int baseDelay = (int)((double)this.period * 0.1);
        this.timer.schedule(this.flushTask, RND.nextInt((int)this.period) + baseDelay, this.period);
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    private class FlushMessageHandlerTask
    extends TimerTask {
        private FlushMessageHandlerTask() {
        }

        public void run() {
            MessageHandlerFlusher.this.logger.debug((Object)("Flushing MessageHandler[" + MessageHandlerFlusher.this.messageHandler + "'"));
            MessageHandlerFlusher.this.messageHandler.flush();
        }
    }
}

