/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.extension.clearpass;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public final class ClearPassController
extends AbstractController {
    private static final Logger log = LoggerFactory.getLogger(ClearPassController.class);
    private static final String DEFAULT_SERVICE_FAILURE_VIEW_NAME = "protocol/clearPass/clearPassFailure";
    private static final String DEFAULT_SERVICE_SUCCESS_VIEW_NAME = "protocol/clearPass/clearPassSuccess";
    private static final String MODEL_CLEARPASS = "credentials";
    private static final String MODEL_FAILURE_DESCRIPTION = "description";
    @NotNull
    private String successView = "protocol/clearPass/clearPassSuccess";
    @NotNull
    private String failureView = "protocol/clearPass/clearPassFailure";
    @NotNull
    private final Map<String, String> credentialsCache;

    public ClearPassController(Map<String, String> credentialsCache) {
        this.credentialsCache = credentialsCache;
    }

    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String userName = request.getRemoteUser();
        log.debug("Handling clearPass request for user " + userName);
        if (userName != null) {
            String password = this.credentialsCache.get(userName);
            return new ModelAndView(this.successView, MODEL_CLEARPASS, (Object)password);
        }
        return this.returnError("No authentication information provided.");
    }

    protected ModelAndView returnError(String description) {
        ModelAndView mv = new ModelAndView(this.failureView);
        mv.addObject(MODEL_FAILURE_DESCRIPTION, (Object)description);
        return mv;
    }

    public void setSuccessView(String successView) {
        this.successView = successView;
    }

    public void setFailureView(String failureView) {
        this.failureView = failureView;
    }
}

