/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.extension.clearpass.integration.uportal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.extension.clearpass.integration.uportal.PasswordCachingCasAssertionSecurityContext;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.ISecurityContextFactory;
import org.springframework.core.io.ClassPathResource;

public final class PasswordCachingCasAssertionSecurityContextFactory
implements ISecurityContextFactory {
    private static final String DEFAULT_PORTAL_SECURITY_PROPERTY_FILE = "properties/security.properties";
    private static final String CLEARPASS_CAS_URL_PROPERTY = String.valueOf(PasswordCachingCasAssertionSecurityContextFactory.class.getName()) + ".clearPassCasUrl";
    private final Log log = LogFactory.getLog(this.getClass());
    private final String clearPassUrl;

    public PasswordCachingCasAssertionSecurityContextFactory() {
        ClassPathResource resource = new ClassPathResource(DEFAULT_PORTAL_SECURITY_PROPERTY_FILE, this.getClass().getClassLoader());
        Properties securityProperties = new Properties();
        InputStream inputStream = null;
        try {
            try {
                inputStream = resource.getInputStream();
                securityProperties.load(inputStream);
                this.clearPassUrl = securityProperties.getProperty(CLEARPASS_CAS_URL_PROPERTY);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public ISecurityContext getSecurityContext() {
        if (CommonUtils.isNotBlank((String)this.clearPassUrl)) {
            return new PasswordCachingCasAssertionSecurityContext(this.clearPassUrl);
        }
        throw new IllegalStateException(String.format("clearPassUrl not configured.  Cannot create an instance of [%s] without it.", this.getClass().getSimpleName()));
    }
}

