/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.validation.constraints.NotNull;
import net.spy.memcached.MemcachedClient;
import org.jasig.cas.monitor.AbstractCacheMonitor;
import org.jasig.cas.monitor.CacheStatistics;
import org.jasig.cas.monitor.CacheStatus;
import org.jasig.cas.monitor.SimpleCacheStatistics;
import org.jasig.cas.monitor.StatusCode;

public class MemcachedMonitor
extends AbstractCacheMonitor {
    @NotNull
    private final MemcachedClient memcachedClient;

    public MemcachedMonitor(MemcachedClient client) {
        this.memcachedClient = client;
    }

    public CacheStatus observe() {
        CacheStatus status;
        if (this.memcachedClient.getAvailableServers().size() == 0) {
            return new CacheStatus(StatusCode.ERROR, "No memcached servers available.", new CacheStatistics[0]);
        }
        Collection unavailableList = this.memcachedClient.getUnavailableServers();
        if (unavailableList.size() > 0) {
            String description = "One or more memcached servers is unavailable: " + unavailableList;
            status = new CacheStatus(StatusCode.WARN, description, this.getStatistics());
        } else {
            status = super.observe();
        }
        return status;
    }

    protected CacheStatistics[] getStatistics() {
        Map allStats = this.memcachedClient.getStats();
        ArrayList<SimpleCacheStatistics> statsList = new ArrayList<SimpleCacheStatistics>();
        for (SocketAddress address : allStats.keySet()) {
            Map statsMap = (Map)allStats.get(address);
            if (statsMap.size() <= 0) continue;
            long size = Long.parseLong((String)statsMap.get("bytes"));
            long capacity = Long.parseLong((String)statsMap.get("limit_maxbytes"));
            long evictions = Long.parseLong((String)statsMap.get("evictions"));
            String name = address instanceof InetSocketAddress ? ((InetSocketAddress)address).getHostName() : address.toString();
            statsList.add(new SimpleCacheStatistics(size, capacity, evictions, name));
        }
        return statsList.toArray(new CacheStatistics[statsList.size()]);
    }
}

