/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support.kryo.serial;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.serialize.SimpleSerializer;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Map;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.ticket.registry.support.kryo.serial.AttributeMapSerializer;

public abstract class AbstractAuthenticationSerializer<T extends Authentication>
extends SimpleSerializer<T> {
    private final Kryo kryo;
    private final AttributeMapSerializer attrSerializer;

    public AbstractAuthenticationSerializer(Kryo kryo) {
        this.kryo = kryo;
        this.attrSerializer = new AttributeMapSerializer(kryo);
    }

    public void write(ByteBuffer buffer, T auth) {
        buffer.putLong(auth.getAuthenticatedDate().getTime());
        this.kryo.writeClassAndObject(buffer, (Object)auth.getPrincipal());
        this.attrSerializer.write(buffer, auth.getAttributes());
    }

    public T read(ByteBuffer buffer) {
        return this.createAuthentication(new Date(buffer.getLong()), (Principal)this.kryo.readClassAndObject(buffer), (Map<String, Object>)this.attrSerializer.read(buffer));
    }

    protected abstract T createAuthentication(Date var1, Principal var2, Map<String, Object> var3);
}

