/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;
import org.springframework.beans.factory.DisposableBean;

public final class MemCacheTicketRegistry
extends AbstractDistributedTicketRegistry
implements DisposableBean {
    @NotNull
    private final MemcachedClientIF client;
    @Min(value=0L)
    private final int tgtTimeout;
    @Min(value=0L)
    private final int stTimeout;

    public MemCacheTicketRegistry(String[] hostnames, int ticketGrantingTicketTimeOut, int serviceTicketTimeOut) {
        try {
            this.client = new MemcachedClient(AddrUtil.getAddresses(Arrays.asList(hostnames)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid memcached host specification.", e);
        }
        this.tgtTimeout = ticketGrantingTicketTimeOut;
        this.stTimeout = serviceTicketTimeOut;
    }

    @Deprecated
    public MemCacheTicketRegistry(long ticketGrantingTicketTimeOut, long serviceTicketTimeOut, String[] hostnames) {
        this(hostnames, (int)(ticketGrantingTicketTimeOut / 1000L), (int)(serviceTicketTimeOut / 1000L));
    }

    public MemCacheTicketRegistry(MemcachedClientIF client, int ticketGrantingTicketTimeOut, int serviceTicketTimeOut) {
        this.tgtTimeout = ticketGrantingTicketTimeOut;
        this.stTimeout = serviceTicketTimeOut;
        this.client = client;
    }

    protected void updateTicket(Ticket ticket) {
        this.logger.debug("Updating ticket {}", (Object)ticket);
        try {
            if (!((Boolean)this.client.replace(ticket.getId(), this.getTimeout(ticket), (Object)ticket).get()).booleanValue()) {
                this.logger.error("Failed updating {}", (Object)ticket);
            }
        }
        catch (InterruptedException e) {
            this.logger.warn("Interrupted while waiting for response to async replace operation for ticket {}. Cannot determine whether update was successful.", (Object)ticket);
        }
        catch (Exception e) {
            this.logger.error("Failed updating {}", (Object)ticket, (Object)e);
        }
    }

    public void addTicket(Ticket ticket) {
        this.logger.debug("Adding ticket {}", (Object)ticket);
        try {
            if (!((Boolean)this.client.add(ticket.getId(), this.getTimeout(ticket), (Object)ticket).get()).booleanValue()) {
                this.logger.error("Failed adding {}", (Object)ticket);
            }
        }
        catch (InterruptedException e) {
            this.logger.warn("Interrupted while waiting for response to async add operation for ticket {}.Cannot determine whether add was successful.", (Object)ticket);
        }
        catch (Exception e) {
            this.logger.error("Failed adding {}", (Object)ticket, (Object)e);
        }
    }

    public boolean deleteTicket(String ticketId) {
        this.logger.debug("Deleting ticket {}", (Object)ticketId);
        try {
            return (Boolean)this.client.delete(ticketId).get();
        }
        catch (Exception e) {
            this.logger.error("Failed deleting {}", (Object)ticketId, (Object)e);
            return false;
        }
    }

    public Ticket getTicket(String ticketId) {
        try {
            Ticket t = (Ticket)this.client.get(ticketId);
            if (t != null) {
                return this.getProxiedTicketInstance(t);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed fetching {} ", (Object)ticketId, (Object)e);
        }
        return null;
    }

    public Collection<Ticket> getTickets() {
        throw new UnsupportedOperationException("GetTickets not supported.");
    }

    public void destroy() throws Exception {
        this.client.shutdown();
    }

    @Deprecated
    public void setSynchronizeUpdatesToRegistry(boolean sync) {
    }

    protected boolean needsCallback() {
        return true;
    }

    private int getTimeout(Ticket t) {
        if (t instanceof TicketGrantingTicket) {
            return this.tgtTimeout;
        }
        if (t instanceof ServiceTicket) {
            return this.stTimeout;
        }
        throw new IllegalArgumentException("Invalid ticket type");
    }
}

