/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support.kryo;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public final class FieldHelper {
    private final Map<String, Field> fieldCache = new HashMap<String, Field>();

    public Object getFieldValue(Object target, String fieldName) {
        Field f = this.getField(target, fieldName);
        try {
            return f.get(target);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Error getting field value", e);
        }
    }

    public void setFieldValue(Object target, String fieldName, Object value) {
        Field f = this.getField(target, fieldName);
        try {
            f.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Error setting field value", e);
        }
    }

    private Field getField(Object target, String name) {
        Class<?> clazz = target.getClass();
        String key = clazz.getName() + '.' + name;
        Field f = this.fieldCache.get(key);
        while (f == null) {
            try {
                f = clazz.getDeclaredField(name);
                f.setAccessible(true);
                this.fieldCache.put(key, f);
            }
            catch (NoSuchFieldException e) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw new IllegalStateException("No such field " + key);
            }
        }
        return f;
    }
}

