/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.jdbc;

import java.security.GeneralSecurityException;
import javax.annotation.PostConstruct;
import javax.security.auth.login.FailedLoginException;
import javax.sql.DataSource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.jasig.cas.adaptors.jdbc.SearchModeSearchDatabaseAuthenticationHandler$AjcClosure1;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component(value="searchModeSearchDatabaseAuthenticationHandler")
public class SearchModeSearchDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler
implements InitializingBean {
    private static final String SQL_PREFIX = "Select count('x') from ";
    @NotNull
    private String fieldUser;
    @NotNull
    private String fieldPassword;
    @NotNull
    private String tableUsers;
    private String sql;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        int count;
        if (StringUtils.isBlank((CharSequence)this.sql) || this.getJdbcTemplate() == null) {
            throw new GeneralSecurityException("Authentication handler is not configured correctly");
        }
        String username = credential.getUsername();
        String encyptedPassword = this.getPasswordEncoder().encode(credential.getPassword());
        try {
            count = (Integer)this.getJdbcTemplate().queryForObject(this.sql, Integer.class, new Object[]{username, encyptedPassword});
        }
        catch (DataAccessException e) {
            throw new PreventedException("SQL exception while executing query for " + username, (Throwable)e);
        }
        if (count == 0) {
            throw new FailedLoginException(String.valueOf(username) + " not found with SQL query.");
        }
        return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username), null);
    }

    @PostConstruct
    public void afterPropertiesSet() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new SearchModeSearchDatabaseAuthenticationHandler$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Autowired
    public final void setFieldPassword(@Value(value="${cas.jdbc.authn.search.password:}") String fieldPassword) {
        this.fieldPassword = fieldPassword;
    }

    @Autowired
    public final void setFieldUser(@Value(value="${cas.jdbc.authn.search.user:}") String fieldUser) {
        this.fieldUser = fieldUser;
    }

    @Autowired
    public final void setTableUsers(@Value(value="${cas.jdbc.authn.search.table:}") String tableUsers) {
        this.tableUsers = tableUsers;
    }

    @Override
    @Autowired(required=false)
    public void setDataSource(@Qualifier(value="searchModeDatabaseDataSource") DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    static {
        SearchModeSearchDatabaseAuthenticationHandler.ajc$preClinit();
    }

    static final /* synthetic */ void afterPropertiesSet_aroundBody0(SearchModeSearchDatabaseAuthenticationHandler ajc$this, JoinPoint joinPoint) {
        if (StringUtils.isNotBlank((CharSequence)ajc$this.tableUsers) || StringUtils.isNotBlank((CharSequence)ajc$this.fieldUser) || StringUtils.isNotBlank((CharSequence)ajc$this.fieldPassword)) {
            ajc$this.sql = SQL_PREFIX + ajc$this.tableUsers + " WHERE " + ajc$this.fieldUser + " = ? AND " + ajc$this.fieldPassword + " = ?";
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SearchModeSearchDatabaseAuthenticationHandler.java", SearchModeSearchDatabaseAuthenticationHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "afterPropertiesSet", "org.jasig.cas.adaptors.jdbc.SearchModeSearchDatabaseAuthenticationHandler", "", "", "", "void"), 73);
    }
}

