/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.ldap;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.jasig.cas.adaptors.ldap.LdapErrorDefinition;
import org.jasig.cas.authentication.LdapAuthenticationException;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.BadCredentialsAuthenticationException;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLdapUsernamePasswordAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler
implements InitializingBean {
    @NotNull
    private LdapTemplate ldapTemplate;
    @NotNull
    private ContextSource contextSource;
    @NotNull
    private String filter;
    private List<LdapErrorDefinition> ldapErrorDefinitions;
    private boolean ignorePartialResultException = false;

    public final void setContextSource(ContextSource contextSource) {
        this.contextSource = contextSource;
    }

    public final void setIgnorePartialResultException(boolean ignorePartialResultException) {
        this.ignorePartialResultException = ignorePartialResultException;
    }

    public void setLdapErrorDefinitions(List<LdapErrorDefinition> ldapErrorDefs) {
        this.ldapErrorDefinitions = ldapErrorDefs;
    }

    protected final LdapTemplate getLdapTemplate() {
        return this.ldapTemplate;
    }

    protected final ContextSource getContextSource() {
        return this.contextSource;
    }

    protected final String getFilter() {
        return this.filter;
    }

    public final void afterPropertiesSet() throws Exception {
        Assert.isTrue((this.filter.contains("%u") || this.filter.contains("%U") ? 1 : 0) != 0, (String)"filter must contain %u or %U");
        if (this.ldapTemplate == null) {
            this.ldapTemplate = new LdapTemplate(this.contextSource);
        }
        this.ldapTemplate.setIgnorePartialResultException(this.ignorePartialResultException);
        this.afterPropertiesSetInternal();
    }

    protected final void setLdapTemplate(LdapTemplate ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
    }

    protected void afterPropertiesSetInternal() throws Exception {
    }

    public final void setFilter(String filter) {
        this.filter = filter;
    }

    protected AuthenticationException handleLdapError(Exception e) {
        if (this.ldapErrorDefinitions == null || this.ldapErrorDefinitions.size() == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("No error definitions are defined. Throwing error " + e.getMessage());
            }
            return BadCredentialsAuthenticationException.ERROR;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handling error: " + e.getMessage());
        }
        for (LdapErrorDefinition ldapErrorDef : this.ldapErrorDefinitions) {
            if (!ldapErrorDef.matches(e.getMessage())) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Found error type " + ldapErrorDef.getType() + ". Throwing error for " + e.getMessage());
            }
            return new LdapAuthenticationException("error.authentication.credentials.bad", e.getMessage(), ldapErrorDef.getType());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("No error definition could be matched against the error. Throwing default error for " + e.getMessage());
        }
        return BadCredentialsAuthenticationException.ERROR;
    }
}

