/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.ldap;

import javax.naming.directory.DirContext;
import org.jasig.cas.adaptors.ldap.AbstractLdapUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.jasig.cas.util.LdapUtils;
import org.springframework.ldap.NamingException;

public class FastBindLdapAuthenticationHandler
extends AbstractLdapUsernamePasswordAuthenticationHandler {
    protected final boolean authenticateUsernamePasswordInternal(UsernamePasswordCredentials credentials) throws AuthenticationException {
        block5: {
            DirContext dirContext = null;
            try {
                String transformedUsername = this.getPrincipalNameTransformer().transform(credentials.getUsername());
                String bindDn = LdapUtils.getFilterWithValues(this.getFilter(), transformedUsername);
                this.log.debug("Performing LDAP bind with credential: " + bindDn);
                dirContext = this.getContextSource().getContext(bindDn, this.getPasswordEncoder().encode(credentials.getPassword()));
                if (dirContext == null) break block5;
            }
            catch (NamingException e) {
                try {
                    this.log.info("Failed to authenticate user {} with error {}", (Object)credentials.getUsername(), (Object)e.getMessage());
                    throw this.handleLdapError((Exception)((Object)e));
                }
                catch (Throwable throwable) {
                    if (dirContext != null) {
                        LdapUtils.closeContext(dirContext);
                    }
                    throw throwable;
                }
            }
            LdapUtils.closeContext(dirContext);
        }
        return true;
    }
}

