/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import org.jasig.cas.authentication.LdapAuthenticationException;
import org.jasig.cas.authentication.LdapPasswordPolicyEnforcementException;
import org.jasig.cas.authentication.PasswordPolicyEnforcer;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public final class PasswordPolicyEnforcementAction
extends AbstractAction
implements InitializingBean {
    private PasswordPolicyEnforcer passwordPolicyEnforcer;
    private String passwordPolicyUrl;

    public final PasswordPolicyEnforcer getPasswordPolicyEnforcer() {
        return this.passwordPolicyEnforcer;
    }

    public String getPasswordPolicyUrl() {
        return this.passwordPolicyUrl;
    }

    public void setPasswordPolicyEnforcer(PasswordPolicyEnforcer enforcer) {
        this.passwordPolicyEnforcer = enforcer;
    }

    public void setPasswordPolicyUrl(String passwordPolicyUrl) {
        this.passwordPolicyUrl = passwordPolicyUrl;
    }

    private void populateErrorsInstance(LdapAuthenticationException e, RequestContext reqCtx) {
        block2: {
            try {
                String code = e.getCode();
                reqCtx.getMessageContext().addMessage(new MessageBuilder().error().code(code).defaultText(code).build());
            }
            catch (Exception fe) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error((Object)fe.getMessage(), (Throwable)fe);
            }
        }
    }

    private final Event warning() {
        return this.result("showWarning");
    }

    protected Event doExecute(RequestContext context) throws Exception {
        Event returnedEvent;
        block17: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Checking account status for password...");
            }
            String ticket = context.getRequestScope().getString("serviceTicketId");
            UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)context.getFlowScope().get("credentials");
            String userId = credentials.getUsername();
            returnedEvent = this.error();
            String msgToLog = null;
            try {
                try {
                    long daysToExpirationDate;
                    if (userId == null && ticket == null) {
                        msgToLog = "No user principal or service ticket available.";
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error((Object)msgToLog);
                        }
                        throw new LdapPasswordPolicyEnforcementException("error.authentication.credentials.bad", msgToLog);
                    }
                    if (userId == null && ticket != null) {
                        returnedEvent = this.success();
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Received service ticket " + ticket + " but no user id. This is not a login attempt, so skip password enforcement."));
                        }
                        break block17;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Retrieving number of days to password expiration date for user " + userId));
                    }
                    if ((daysToExpirationDate = this.getPasswordPolicyEnforcer().getNumberOfDaysToPasswordExpirationDate(userId)) == -1L) {
                        returnedEvent = this.success();
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Password for " + userId + " is not expiring"));
                        }
                        break block17;
                    }
                    returnedEvent = this.warning();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Password for " + userId + " is expiring in " + daysToExpirationDate + " days"));
                    }
                    context.getFlowScope().put("expireDays", (Object)daysToExpirationDate);
                }
                catch (LdapAuthenticationException e) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error((Object)e.getMessage(), (Throwable)((Object)e));
                    }
                    this.populateErrorsInstance(e, context);
                    returnedEvent = this.error();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Switching to flow event id " + returnedEvent.getId() + " for user " + userId));
                    }
                }
            }
            finally {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Switching to flow event id " + returnedEvent.getId() + " for user " + userId));
                }
            }
        }
        return returnedEvent;
    }

    protected void initAction() throws Exception {
        Assert.notNull((Object)this.getPasswordPolicyEnforcer(), (String)"password policy enforcer cannot be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Initialized the action with password policy enforcer " + this.getPasswordPolicyEnforcer().getClass().getName()));
        }
    }
}

